/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperBaseAbstractProvider;
import java.text.ParseException;
import java.util.Date;

public abstract class RzdReservationCreationWrapperTrainAbstractProvider
extends RzdReservationCreationWrapperBaseAbstractProvider {
    private final RzdTrain train;
    private final EntityContainer<? extends BaseRailGdsAccount> gdsAccountCtr;

    public RzdReservationCreationWrapperTrainAbstractProvider(SalesContext salesContext, RzdTrain train, RzdGdsParameters gdsParams, EntityReference<Organization> supplier) {
        super(salesContext, gdsParams, supplier);
        this.train = train;
        this.gdsAccountCtr = EntityStorage.get().resolve(train.getGdsAccount());
    }

    @Override
    public GdsName getGds() {
        return this.train.getGds();
    }

    @Override
    public EntityReference<BaseGdsAccount> getGdsAccount() {
        return this.train.getGdsAccount();
    }

    @Override
    public DictionaryReference<RailwayStation> getDepartureStation() {
        return this.train.getPassengerFrom();
    }

    @Override
    public DictionaryReference<RailwayStation> getArriveStation() {
        return this.train.getPassengerTo();
    }

    @Override
    public Date getDepartureDate() throws ParseException {
        return this.train.getDepartureDatetime();
    }

    @Override
    public Date getArriveDate() throws ParseException {
        return this.train.getArrivalDatetime();
    }

    @Override
    public Date getLocalDepartureDate() throws ParseException {
        return this.train.getLocalDepartureDatetime();
    }

    @Override
    public Date getLocalArriveDate() throws ParseException {
        return this.train.getLocalArrivalDatetime();
    }

    @Override
    public Date geTrainArriveDate() {
        return this.train.getArrivalDatetime();
    }

    @Override
    public Date getLocalTrainArriveDate() {
        return this.train.getLocalArrivalDatetime();
    }

    @Override
    public String getBrand() {
        return this.train.getBrand();
    }

    @Override
    public String getTrainCategory() {
        return this.train.getCategory();
    }

    @Override
    public String getTrainArrivalLocation() {
        return this.train.getArrival();
    }

    @Override
    public String getTrainDepartureLocation() {
        return this.train.getDeparture();
    }

    @Override
    public Date getTrainDepartureDate() {
        return this.train.getTrainDepartureDate();
    }

    @Override
    public String getTrainProvider() {
        return this.train.getTrainProvider();
    }

    @Override
    public Boolean getInternational() {
        return this.train.isInternational();
    }

    @Override
    public int getDurationInMinutes() {
        return MiscUtil.guarded((Integer)this.train.getWayTime());
    }

    @Override
    public String getTrainNumber() {
        return this.train.getNumber();
    }

    @Override
    public String getTrainNumberInSearch() {
        return this.train.getDisplayNumber();
    }

    @Override
    public String getTrainNumberOriginal() {
        return this.train.getNumber();
    }

    @Override
    public Integer getDirectionGroup() {
        return this.train.getDirectionGroup();
    }

    @Override
    public boolean isERegEnabled() {
        return this.train.isERegEnabled();
    }

    @Override
    public String getAddInfo() {
        return this.train.getAddInfo();
    }

    @Override
    public boolean isHasEReg() {
        return this.train.isERegEnabled();
    }

    @Override
    public String getGdsCurrency() {
        if (this.gdsAccountCtr.getEntity() != null) {
            BaseRailGdsAccount gdsAccount = (BaseRailGdsAccount)this.gdsAccountCtr.getEntity();
            if (gdsAccount.getCurrency() == null) {
                return null;
            }
            return gdsAccount.getCurrency().getCode();
        }
        return null;
    }
}

