/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersExPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProxyHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RzdReservationParamsRulesProperties
implements RzdParametersExPropertiesProvider {
    private static final long serialVersionUID = 4557197226344135595L;
    private final Set<String> blankOwners = new HashSet<String>();
    private final Date issueDate;
    private String validatorCode;
    private String salesPoint;
    private final Set<String> departureLocations = new HashSet<String>();
    private final Set<String> arriveLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private final List<String> trainNumbers = new ArrayList<String>();
    private final List<String> carriageTypes = new ArrayList<String>();
    private final List<String> serviceClasses = new ArrayList<String>();
    private final Date departureDate;
    private final Date arrivalDate;
    private final Date departureDateLocal;
    private final Date arrivalDateLocal;
    private final Set<String> fopTypes = new HashSet<String>();
    private final String gdsName;
    private final EntityReference<? extends BaseGdsAccount> gdsAccount;
    private boolean eticket;
    private final TransportationType transportationType;
    private final List<String> carriers = new ArrayList<String>();
    private final List<String> trainTypes = new ArrayList<String>();
    private final List<String> serviceLists = new ArrayList<String>();
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private final EntityReference<Person> agent;
    private final EntityReference<Organization> client;
    private final int travelDuration;
    private final String agencyCode;
    private String branchUid;
    private final String reservationType;
    private final EntityReference<Organization> supplier;

    public RzdReservationParamsRulesProperties(RzdReservationCreationParameters params, SalesContext salesContext, EntityReference<Organization> blankOwnerRef, EntityReference<Organization> supplierRef) {
        DictionaryReference arriveStation;
        EntityReference salesPointRef;
        this.agencyCode = CommonHelper.getAgencyCode((SalesContext)salesContext);
        this.supplier = supplierRef;
        this.reservationType = ReservationType.IBE.name();
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        if (blankOwnerCtr != null) {
            Organization blankOwner = (Organization)EntityStorage.get().resolve(blankOwnerRef).getEntity();
            this.blankOwners.clear();
            this.blankOwners.add(blankOwner.getCode());
            this.blankOwners.addAll(blankOwner.getShortName().getValues().values());
            this.blankOwners.addAll(blankOwner.getFullName().getValues().values());
        }
        this.issueDate = new Date();
        Validator validator = RzdHelper.findValidator((EntityReference<SalesPoint>)salesContext.getSalesPoint(), (EntityReference<Organization>)salesContext.getAgency(), blankOwnerRef, supplierRef);
        if (validator != null) {
            this.validatorCode = this.getString(validator.getNumber());
        }
        if ((salesPointRef = salesContext.getSalesPoint()) != null) {
            this.salesPoint = salesPointRef.getUid();
        }
        this.departureLocations.clear();
        this.arriveLocations.clear();
        this.visitedCities.clear();
        this.trainNumbers.clear();
        this.carriageTypes.clear();
        this.serviceClasses.clear();
        RzdTrain rzdTrain = params.getSegment().getTrain();
        RzdPrice rzdPrice = params.getSegment().getRzdPrice();
        this.gdsAccount = rzdTrain.getGdsAccount();
        this.gdsName = this.getEnumName(rzdTrain.getGds());
        HashSet<String> geoCodes = new HashSet<String>();
        DictionaryReference departureStation = rzdTrain.getPassengerFrom();
        if (departureStation != null) {
            geoCodes.add(departureStation.getCode());
            geoCodes.addAll(RailwayProxyHelper.collectRailwayStationCodes(geoCodes));
            this.departureLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[0]));
        }
        if ((arriveStation = rzdTrain.getPassengerTo()) != null) {
            geoCodes.clear();
            geoCodes.add(arriveStation.getCode());
            geoCodes.addAll(RailwayProxyHelper.collectRailwayStationCodes(geoCodes));
            this.arriveLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[0]));
        }
        String trainNumber = rzdPrice.getTrainNumber() == null ? null : rzdPrice.getTrainNumber().replaceAll("\\D+$", "");
        this.trainNumbers.add(trainNumber);
        if (!Objects.equals(trainNumber, rzdPrice.getTrainNumber())) {
            this.trainNumbers.add(rzdPrice.getTrainNumber());
        }
        this.departureDate = rzdTrain.getDepartureDatetime();
        this.arrivalDate = rzdTrain.getArrivalDatetime();
        this.departureDateLocal = rzdTrain.getLocalDepartureDatetime();
        this.arrivalDateLocal = rzdTrain.getLocalArrivalDatetime();
        this.eticket = params.getSegment().getRzdCar().isERegEnabled();
        if (this.eticket && params.getSegmentBack() != null) {
            this.eticket = params.getSegmentBack().getRzdCar().isERegEnabled();
        }
        this.fopTypes.clear();
        this.fopTypes.add(this.getEnumName(PaymentType.INVOICE));
        this.carriageTypes.add(this.getEnumName(rzdPrice.getCategory()));
        this.transportationType = RailwayProductHelper.getTransportationType((DictionaryReference)departureStation, (DictionaryReference)arriveStation);
        this.trainTypes.clear();
        if (!TextUtil.isBlank((String)rzdTrain.getBrand())) {
            this.trainTypes.add(rzdTrain.getBrand());
        }
        this.serviceLists.clear();
        if (rzdPrice.getServiceList() != null) {
            this.serviceLists.add(rzdPrice.getServiceList());
        }
        RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)salesContext.getSubagency());
        this.agent = salesContext.getAgent();
        this.client = salesContext.getClient();
        this.travelDuration = rzdTrain.getWayTime() != null ? rzdTrain.getWayTime() : 0;
    }

    public Set<String> getBlankOwners() {
        return this.blankOwners;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getValidatorCode() {
        return this.validatorCode;
    }

    public String getSalesPoint() {
        return this.salesPoint;
    }

    public String getPnr() {
        return null;
    }

    public int getSegmentsAmount() {
        return 1;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public Set<String> getArrivalLocations() {
        return this.arriveLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public List<String> getTrainNumbers() {
        return this.trainNumbers;
    }

    public List<String> getCarriageTypes() {
        return this.carriageTypes;
    }

    public List<String> getServiceClasses() {
        return this.serviceClasses;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public Date getArrivalDate() {
        return this.arrivalDate;
    }

    public Date getArrivalDateLocal() {
        return this.arrivalDateLocal;
    }

    public Date getDepartureDateLocal() {
        return this.departureDateLocal;
    }

    public Set<String> getFopTypes() {
        return this.fopTypes;
    }

    public String getPassengerStatus() {
        return null;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public BigDecimal getTotalEquivalentFare() {
        return null;
    }

    public BigDecimal getPreviousSellTotalEquivalentFare() {
        return null;
    }

    public List<String> getCarriers() {
        return this.carriers;
    }

    public List<String> getTrainTypes() {
        return this.trainTypes;
    }

    public List<String> getServiceLists() {
        return this.serviceLists;
    }

    public Set<String> getPassengerTypes() {
        return Collections.singleton(DictHelper.getAdultPassengerType().getCode());
    }

    public Set<String> getPassengerTypeCategories() {
        return new HashSet<String>(RulesHelper.getPassengerTypeCategoryCodes((DictionaryReference)DictHelper.getAdultPassengerType()));
    }

    public TransportationType getTransportationType() {
        return this.transportationType;
    }

    private <E extends Enum<?>> String getEnumName(E value) {
        if (value == null) {
            return null;
        }
        return value.name();
    }

    private String getString(String value) {
        return TextUtil.isBlank((String)value) ? null : value.trim();
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public int getTravelDuration() {
        return this.travelDuration;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public String getBranchUid() {
        return this.branchUid;
    }

    public String getReservationType() {
        return this.reservationType;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public RailwayMcoCategory getRailwayMcoCategory() {
        return null;
    }
}

