/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.xtrip.common.ibecorp.model.RzdCalcTrainDepartureDateParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoutePoint;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

public class TrainDepartureDateCalculator
extends BaseProcessor {
    private static String TIME_SEP = ":";

    public void process(MessageContext ctx) throws Exception {
        RzdCalcTrainDepartureDateParameters params = (RzdCalcTrainDepartureDateParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_CALC_TRAIN_DEPARTURE_DATE_PARAMETERS);
        Collection routes = (Collection)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_ROUTES);
        Date trainDate = this.calcTrainDepartureDate(params, routes);
        SimpleDateFormat dtFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430: {0}", (Object[])new Object[]{dtFormat.format(trainDate)}));
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_DEPARTURE_DATE, (Object)trainDate);
    }

    private Date calcTrainDepartureDate(RzdCalcTrainDepartureDateParameters params, Collection<RzdRoute> routes) {
        if (routes.isEmpty()) {
            return null;
        }
        Date result = null;
        RzdRoute rzdRoute = this.getMainRoute(routes);
        if (!rzdRoute.getPoints().isEmpty()) {
            RzdRoutePoint firstPoint = (RzdRoutePoint)rzdRoute.getPoints().get(0);
            int hh = Integer.valueOf(firstPoint.getDepartureTime().split(TIME_SEP)[0]);
            int min = Integer.valueOf(firstPoint.getDepartureTime().split(TIME_SEP)[1]);
            Calendar trainCal = Calendar.getInstance();
            if (params.getTrainDepartureDate() != null) {
                trainCal.setTime(params.getTrainDepartureDate());
                trainCal.set(11, hh);
                trainCal.set(12, min);
                return trainCal.getTime();
            }
            Date stationDate = params.getPassengerDepartureDatetime();
            trainCal.setTime(stationDate);
            trainCal.set(11, hh);
            trainCal.set(12, min);
            int daysBefore = 0;
            boolean findStation = false;
            String lastTime = null;
            RailwayStation station = (RailwayStation)DictionaryCache.get().resolveReference(params.getPassengerFrom());
            if (station != null) {
                String passengerStationCode = DictHelper.getCodeVariant((BaseDictionary)station, (CodeSystem)CodeSystem.EXPRESS);
                for (RzdRoutePoint point : rzdRoute.getPoints()) {
                    String timeStr;
                    if (TextUtil.isBlank((String)point.getStationCode())) continue;
                    String string = timeStr = TextUtil.isBlank((String)point.getDepartureTime()) ? point.getArrivalTime() : point.getDepartureTime();
                    if (!TextUtil.isBlank((String)timeStr)) {
                        if (this.pointBefore(timeStr, lastTime)) {
                            --daysBefore;
                        }
                        lastTime = timeStr;
                    }
                    if (!point.getStationCode().equals(passengerStationCode)) continue;
                    findStation = true;
                    break;
                }
            }
            if (!findStation) {
                daysBefore = 0;
            }
            trainCal.add(5, daysBefore);
            if (trainCal.getTime().after(stationDate)) {
                trainCal.add(5, -1);
            }
            result = trainCal.getTime();
        }
        return result;
    }

    private RzdRoute getMainRoute(Collection<RzdRoute> routes) {
        if (routes.isEmpty()) {
            return null;
        }
        if (routes.size() == 1) {
            return routes.iterator().next();
        }
        for (RzdRoute route : routes) {
            if (!route.getTitle().equalsIgnoreCase("\u041e\u0421\u041d\u041e\u0412\u041d\u041e\u0419 \u041c\u0410\u0420\u0428\u0420\u0423\u0422")) continue;
            return route;
        }
        return null;
    }

    private boolean pointBefore(String curTime, String lastTime) {
        if (TextUtil.isBlank((String)lastTime)) {
            return false;
        }
        int curHh = Integer.valueOf(curTime.split(TIME_SEP)[0]);
        int curMin = Integer.valueOf(curTime.split(TIME_SEP)[1]);
        int lastHh = Integer.valueOf(lastTime.split(TIME_SEP)[0]);
        int lastMin = Integer.valueOf(lastTime.split(TIME_SEP)[1]);
        if (curHh < lastHh) {
            return true;
        }
        if (curHh > lastHh) {
            return false;
        }
        return curMin < lastMin;
    }
}

