/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class UpdateRailwayReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        RzdBookingSegmentParams segmentParams = (RzdBookingSegmentParams)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_BOOKING_SEGMENT_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PaymentType paymentType = (PaymentType)ctx.getObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        RzdGdsParameters gdsParams = (RzdGdsParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityReference supplierRef = (EntityReference)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SUPPLIER_REF);
        reservation.getGdsNameInfo().setOnlineGdsAccount(accountCtr.toReference());
        this.updateValue(() -> ((Reservation)reservation).getSubagency(), arg_0 -> ((Reservation)reservation).setSubagency(arg_0), salesContext.getSubagency());
        this.updateValue(() -> ((Reservation)reservation).getSalesPoint(), arg_0 -> ((Reservation)reservation).setSalesPoint(arg_0), salesContext.getSalesPoint());
        this.updateValue(() -> ((Reservation)reservation).getBookingAgent(), arg_0 -> ((Reservation)reservation).setBookingAgent(arg_0), salesContext.getAgent());
        this.updateValue(() -> ((Reservation)reservation).getTimeLimit(), arg_0 -> ((Reservation)reservation).setTimeLimit(arg_0), gdsParams.getTimelimit());
        for (RailwayProduct product : RailwayHelper.getProducts(reservation, segmentParams)) {
            this.updateProduct(product, salesContext, (EntityReference<Organization>)supplierRef, segmentParams, gdsParams, paymentType);
        }
    }

    private void updateProduct(RailwayProduct product, SalesContext salesContext, EntityReference<Organization> supplierRef, RzdBookingSegmentParams segmentParams, RzdGdsParameters gdsParams, PaymentType paymentType) {
        BigDecimal minPrice;
        this.updateValue(() -> ((RailwayProduct)product).getPaymentType(), arg_0 -> ((RailwayProduct)product).setPaymentType(arg_0), paymentType);
        EntityReference agency = salesContext.getAgency();
        EntityReference blankOwner = gdsParams.getBlankOwner();
        EntityReference salesPoint = salesContext.getSalesPoint();
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, supplierRef);
        RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)agency);
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)salesContext.getSubagency());
        product.setSalesPoint(salesPoint);
        product.setCashier(salesContext.getAgent());
        this.updateValue(() -> ((RailwayProduct)product).getBlankOwnerRef(), arg_0 -> ((RailwayProduct)product).setBlankOwnerRef(arg_0), blankOwner);
        EntityReference blankOwnerRef = product.getBlankOwnerRef();
        DictionaryReference blankTypeRef = BookingHelper.getBlankType((EntityReference)blankOwnerRef, (boolean)false);
        this.updateValue(() -> ((RailwayProduct)product).getBlankType(), arg_0 -> ((RailwayProduct)product).setBlankType(arg_0), blankTypeRef);
        if (TextUtil.isBlank((String)product.getValidatorCode()) && product.getValidatorRef() == null) {
            Validator validator = RzdHelper.findValidator((EntityReference<SalesPoint>)salesPoint, (EntityReference<Organization>)agency, (EntityReference<Organization>)blankOwner, supplierRef);
            if (validator != null) {
                product.setValidatorCode(validator.getNumber());
                product.setValidatorRef(new NestedEntityReference(salesPoint, (BaseEntity)validator));
            } else {
                this.log.error(String.format("Can't find validator for salesPoint %s, agency %s, blankOwner %s, supplier %s", salesPoint, agency, blankOwner, supplierRef));
            }
        }
        if ((minPrice = segmentParams.getMinPrice()) != null && (product.getStatisticalData() == null || product.getStatisticalData().getMinPriceRailway() == null)) {
            if (product.getStatisticalData() == null) {
                product.setStatisticalData(new StatisticalData());
            }
            product.getStatisticalData().setMinPriceRailway(minPrice);
        }
        RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
        RzdTrain train = segmentParams.getTrain();
        RzdPrice rzdPrice = segmentParams.getRzdPrice();
        RzdCar rzdCar = segmentParams.getRzdCar();
        PlacingRequirements placing = segmentParams.getPlacing();
        this.updateValue(() -> ((RailwaySegment)segment).getTrainCategory(), arg_0 -> ((RailwaySegment)segment).setTrainCategory(arg_0), train.getCategory());
        this.updateValue(() -> ((RailwaySegment)segment).getDurationInMinutes(), arg_0 -> ((RailwaySegment)segment).setDurationInMinutes(arg_0), train.getWayTime());
        this.updateValue(() -> ((RailwaySegment)segment).getArrivalLocation(), arg_0 -> ((RailwaySegment)segment).setArrivalLocation(arg_0), train.getArrival());
        this.updateValue(() -> ((RailwaySegment)segment).getDepartureLocation(), arg_0 -> ((RailwaySegment)segment).setDepartureLocation(arg_0), train.getDeparture());
        this.updateValue(() -> ((RailwaySegment)segment).getTrainNumberInSearch(), arg_0 -> ((RailwaySegment)segment).setTrainNumberInSearch(arg_0), train.getDisplayNumber());
        this.updateValue(() -> ((RailwaySegment)segment).getTrainNumberOriginal(), arg_0 -> ((RailwaySegment)segment).setTrainNumberOriginal(arg_0), train.getNumber());
        this.updateValue(() -> ((RailwaySegment)segment).getBrand(), arg_0 -> ((RailwaySegment)segment).setBrand(arg_0), train.getBrand());
        this.updateValue(() -> ((RailwaySegment)segment).getAddInfo(), arg_0 -> ((RailwaySegment)segment).setAddInfo(arg_0), train.getAddInfo());
        this.updateValue(() -> ((RailwaySegment)segment).getCarrier(), arg_0 -> ((RailwaySegment)segment).setCarrier(arg_0), rzdPrice.getCarrier());
        this.updateValue(() -> ((RailwaySegment)segment).getDirectionGroup(), arg_0 -> ((RailwaySegment)segment).setDirectionGroup(arg_0), rzdPrice.getDirectionGroup());
        this.updateValue(() -> ((RailwaySegment)segment).getCarrierRoute(), arg_0 -> ((RailwaySegment)segment).setCarrierRoute(arg_0), rzdPrice.getRoute());
        this.updateValue(() -> ((RailwaySegment)segment).getCarrierSubcategory(), arg_0 -> ((RailwaySegment)segment).setCarrierSubcategory(arg_0), rzdPrice.getSubcategory());
        this.updateValue(() -> ((RailwaySegment)segment).getCarriageTypeTitle(), arg_0 -> ((RailwaySegment)segment).setCarriageTypeTitle(arg_0), rzdPrice.getCategoryTitle());
        this.updateValue(() -> ((RailwaySegment)segment).getServiceDescription(), arg_0 -> ((RailwaySegment)segment).setServiceDescription(arg_0), rzdPrice.getServiceDescription());
        this.updateValue(() -> ((RailwaySegment)segment).getServiceList(), arg_0 -> ((RailwaySegment)segment).setServiceList(arg_0), rzdPrice.getServiceList());
        this.updateValue(() -> ((RailwaySegment)segment).getSeatsGroupSize(), arg_0 -> ((RailwaySegment)segment).setSeatsGroupSize(arg_0), rzdPrice.getSeatsIncluded(), v -> v == 0);
        this.updateValue(() -> ((RailwaySegment)segment).getTwoFloors(), arg_0 -> ((RailwaySegment)segment).setTwoFloors(arg_0), rzdCar.isTwoStoreyed());
        this.updateValue(() -> ((RailwaySegment)segment).getProviderCarSchemeId(), arg_0 -> ((RailwaySegment)segment).setProviderCarSchemeId(arg_0), rzdCar.getProviderCarSchemeId());
        this.updateValue(() -> ((RailwaySegment)segment).getSchema(), arg_0 -> ((RailwaySegment)segment).setSchema(arg_0), rzdCar.getSchema());
        segment.setHasNonRefundableTariff(rzdCar.isHasNonRefundableTariff());
        this.updateValue(() -> ((RailwaySegment)segment).getCompartmentType(), arg_0 -> ((RailwaySegment)segment).setCompartmentType(arg_0), placing.getGender());
        String carriageCardId = Optional.ofNullable(RailwayHelper.findCarriageCardId(rzdPrice, rzdCar)).map(Enum::name).orElse(null);
        this.updateValue(() -> ((RailwaySegment)segment).getCarriageCardId(), arg_0 -> ((RailwaySegment)segment).setCarriageCardId(arg_0), carriageCardId);
        this.updateValue(() -> ((RailwaySegment)segment).getServicesList(), segment.getServicesList()::addAll, rzdPrice.getServicesList(), List::isEmpty);
    }

    private <T> void updateValue(Supplier<T> getter, Consumer<T> setter, T value) {
        this.updateValue(getter, setter, value, Objects::isNull);
    }

    private <T> void updateValue(Supplier<T> getter, Consumer<T> setter, T value, Predicate<T> isEmpty) {
        if (isEmpty.test(getter.get())) {
            setter.accept(value);
        }
    }
}

