/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.getTrainSeats;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainSeatPrice;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperTrainPriceAbstractProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.SearchPassengerParamsProvider;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class RzdTrainPriceProductCreateParamsBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        RzdGdsParameters gdsParams = (RzdGdsParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityReference supplierRef = (EntityReference)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SUPPLIER_REF);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        RzdGetTrainSeatsParameters searchParams = (RzdGetTrainSeatsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_PARAMETERS);
        RzdTrainSeatPrice seatPrice = (RzdTrainSeatPrice)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_SEAT_PRICE);
        RzdTrain train = (RzdTrain)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN);
        if (train == null) {
            train = this.buildRzdTrain((EntityContainer<BaseRailGdsAccount>)accountCtr, searchParams);
        }
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_CREATE_RESERVATION_PARAMETERS, (Object)this.buildCreateReservationParams(gdsParams, salesContext, searchParams, seatPrice, (EntityReference<Organization>)supplierRef, train));
    }

    private RzdTrain buildRzdTrain(EntityContainer<BaseRailGdsAccount> accountCtr, RzdGetTrainSeatsParameters searchParams) {
        RzdTrain result = new RzdTrain();
        result.setGds(((BaseRailGdsAccount)accountCtr.getEntity()).getGds());
        result.setGdsAccount(accountCtr.toReference());
        result.setPassengerFrom(searchParams.getDeparture());
        result.setPassengerTo(searchParams.getArrival());
        result.setDepartureDatetime(searchParams.getDepartureDate());
        result.setNumber(searchParams.getTrainNumber());
        return result;
    }

    private RzdReservationCreationWrapperProvider buildCreateReservationParams(RzdGdsParameters gdsParams, SalesContext salesContext, RzdGetTrainSeatsParameters params, final RzdTrainSeatPrice seatPrice, EntityReference<Organization> supplier, RzdTrain train) {
        RzdReservationCreationWrapperTrainPriceAbstractProvider result = new RzdReservationCreationWrapperTrainPriceAbstractProvider(salesContext, train, seatPrice.getRzdPrice(), gdsParams, supplier){

            @Override
            public String getRecordLocator() {
                return null;
            }

            @Override
            public Date getCreateDate() {
                return new Date();
            }

            @Override
            public List<Traveller> getTravellers() {
                return Collections.emptyList();
            }

            @Override
            public String getComfortInfo() {
                return null;
            }

            @Override
            public Boolean getWithBedding() {
                return seatPrice.isWithBedding();
            }

            @Override
            public String getCarriageNumber() {
                return null;
            }

            @Override
            public CompartmentType getCompartmentType() {
                return null;
            }

            @Override
            public DictionaryReference<RailwayCarrier> getCarrier() {
                return null;
            }

            @Override
            public String getTimeInfo() {
                return null;
            }

            @Override
            public List<RzdReservationCreationWrapperProvider.PassengerParamsProvider> getPassengers() {
                ArrayList<RzdReservationCreationWrapperProvider.PassengerParamsProvider> psgrParams = new ArrayList<RzdReservationCreationWrapperProvider.PassengerParamsProvider>();
                final BigDecimal price = seatPrice.getPrice();
                psgrParams.add(new SearchPassengerParamsProvider(){

                    @Override
                    public BigDecimal getPrice() {
                        return price;
                    }

                    @Override
                    public DictionaryReference<PassengerType> getPassengerType() {
                        if (seatPrice.isChild()) {
                            return DictHelper.getChildPassengerType();
                        }
                        return super.getPassengerType();
                    }
                });
                return psgrParams;
            }

            @Override
            public boolean isTwoFloors() {
                return false;
            }
        };
        return result;
    }
}

