/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.getTrainSeats;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsResult;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPriceValues;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainSeatPrice;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RzdTrainSeatPricesBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdGetTrainSeatsResult trainSeatsResult = (RzdGetTrainSeatsResult)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_RESULT);
        ArrayList<RzdTrainSeatPrice> result = new ArrayList<RzdTrainSeatPrice>();
        for (RzdPrice rzdPrice : trainSeatsResult.getPrices()) {
            result.addAll(this.getTrainSeatPrices(rzdPrice, rzdPrice.getPrice(), false));
            result.addAll(this.getTrainSeatPrices(rzdPrice, rzdPrice.getChildPrice(), true));
        }
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_SEAT_PRICE_LIST, result);
    }

    private Collection<RzdTrainSeatPrice> getTrainSeatPrices(RzdPrice rzdPrice, RzdPriceValues priceValues, boolean isChild) {
        if (priceValues == null) {
            return Collections.emptyList();
        }
        List<BigDecimal> prices = this.generatePrices(Arrays.asList(priceValues.getOriginalMin(), priceValues.getOriginal()));
        ArrayList<RzdTrainSeatPrice> result = new ArrayList<RzdTrainSeatPrice>();
        for (BigDecimal price : prices) {
            RzdTrainSeatPrice tsp = new RzdTrainSeatPrice();
            tsp.setRzdPrice(rzdPrice);
            tsp.setPrice(price);
            tsp.setChild(isChild);
            result.add(tsp);
        }
        return result;
    }

    private List<BigDecimal> generatePrices(List<BigDecimal> list) {
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
        block0: for (BigDecimal source : list) {
            BigDecimal notNullSource = source == null ? BigDecimal.ZERO : source;
            for (BigDecimal el : result) {
                if (notNullSource.compareTo(el) != 0) continue;
                continue block0;
            }
            result.add(notNullSource);
        }
        return result;
    }
}

