/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.getTrainSeats;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPriceValues;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainSeatPrice;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RzdTrainSeatsAddBookingCommissionProcessor
extends BaseProcessor {
    private static final String TRACE_DOC_PART_NAME = "commission-calculator";

    public void process(MessageContext ctx) throws Exception {
        List seatPrices = (List)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_SEAT_PRICE_LIST);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        GdsTracingDocument document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean toTrace = document != null && gdsTracingSettings != null && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder<RzdPrice> tracingBuilder = new GdsTracingItemBuilder<RzdPrice>(){

            protected String getTitle(RzdPrice variant) {
                StringBuilder sb = new StringBuilder();
                for (RzdCar car : variant.getCars()) {
                    if (sb.length() != 0) {
                        sb.append(",");
                    }
                    sb.append(car.getNumber());
                }
                return sb.toString();
            }
        };
        if (toTrace) {
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            StringBuilder traceBuilder = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            ObjectTrace.trace((Appendable)sb, (Object)salesContext);
            String msg = String.format("calculating commissions for sales context\r\n%s\r\n", sb);
            traceBuilder.append(msg);
            tracingBuilder.traceGlobalLogic(traceBuilder.toString());
        }
        for (RzdTrainSeatPrice seatPrice : seatPrices) {
            String resUid = RailwayHelper.generateReservationUid(seatPrice);
            Reservation res = (Reservation)CollectionUtil.find((Iterable)((BookingFile)bookingCtr.getEntity()).getReservations(), (String)resUid);
            RailwayProduct product = Objects.requireNonNull(RzdCommonHelper.getProduct((Reservation)res));
            RzdPrice rzdPrice = seatPrice.getRzdPrice();
            RzdPriceValues priceValues = seatPrice.isChild() ? rzdPrice.getChildPrice() : rzdPrice.getPrice();
            GeneralProductContractRelationData clientCR = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
            String currencyCode = clientCR.getGeneralData().getCurrency().getCode();
            XtripPriceStructure priceStructure = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)product, (boolean)false);
            BigDecimal fare = priceStructure.getProductPrice();
            BigDecimal total = priceStructure.getTotal();
            BigDecimal fees = MiscUtil.sub((BigDecimal)total, (BigDecimal[])new BigDecimal[]{fare});
            BigDecimal gdsPrice = seatPrice.getPrice();
            if (MiscUtil.compare((Comparable)gdsPrice, (Comparable)MiscUtil.guarded((BigDecimal)priceValues.getOriginal())) == 0) {
                priceValues.setGdsPrice(gdsPrice);
                priceValues.setOriginal(fare);
                priceValues.setFull(total);
                priceValues.setFees(fees);
                this.traceVariant(toTrace, seatPrice, "\u0426\u0435\u043d\u0430", gdsPrice, fare, total, currencyCode, product.getUid(), (BookingFile)bookingCtr.getEntity(), tracingBuilder);
            }
            if (MiscUtil.compare((Comparable)gdsPrice, (Comparable)MiscUtil.guarded((BigDecimal)priceValues.getOriginalMin())) != 0) continue;
            priceValues.setGdsPriceMin(gdsPrice);
            priceValues.setOriginalMin(fare);
            priceValues.setFullMin(total);
            priceValues.setFees(fees);
            this.traceVariant(toTrace, seatPrice, "\u041c\u0438\u043d. \u0446\u0435\u043d\u0430", gdsPrice, fare, total, currencyCode, product.getUid(), (BookingFile)bookingCtr.getEntity(), tracingBuilder);
        }
        if (toTrace) {
            document.getParts().add(tracingBuilder.buildGdsTracingDocumentPart(TRACE_DOC_PART_NAME));
        }
    }

    private void traceVariant(boolean toTrace, RzdTrainSeatPrice seatPrice, String priceDescription, BigDecimal gdsPrice, BigDecimal fare, BigDecimal total, String currencyCode, String productUid, BookingFile bf, GdsTracingItemBuilder<RzdPrice> tracingBuilder) {
        if (!toTrace) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(priceDescription);
        sb.append(seatPrice.isChild() ? " \u0434\u0435\u0442\u0441\u043a\u0438\u0439" : " \u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0439");
        sb.append(seatPrice.isWithBedding() ? " \u0441 \u0431\u0435\u043b\u044c\u0435\u043c" : " \u0431\u0435\u0437 \u0431\u0435\u043b\u044c\u044f");
        sb.append(String.format(" (%s = %s %s)", gdsPrice, fare, currencyCode));
        sb.append("\n");
        List<AppliedRule> appliedRules = this.getProductAppliedRules(productUid, bf);
        this.traceAppliedRules(sb, appliedRules);
        sb.append(String.format("\u0418\u0442\u043e\u0433\u043e \u0441\u043e \u0441\u0431\u043e\u0440\u0430\u043c\u0438 = %s %s\n", total, currencyCode));
        tracingBuilder.traceFlightLogic((BaseEntity)seatPrice.getRzdPrice(), MessageType.MESSAGE, sb.toString());
    }

    private void traceAppliedRules(StringBuilder sb, List<AppliedRule> appliedRules) {
        for (AppliedRule ar : appliedRules) {
            sb.append(String.format("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \"%s\", \u043f\u0440\u0430\u0432\u0438\u043b\u043e \"%s\", \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: \"%s\"\n", ar.getContract(), ar.getRuleName(), ar.getRuleDescription()));
        }
    }

    private List<AppliedRule> getProductAppliedRules(String productUid, BookingFile bf) {
        if (TextUtil.isBlank((String)productUid)) {
            return Collections.emptyList();
        }
        ArrayList<AppliedRule> result = new ArrayList<AppliedRule>();
        for (AppliedRule ar : bf.getAppliedRules()) {
            if (!productUid.equals(ar.getProductUid())) continue;
            result.add(ar);
        }
        return result;
    }
}

