/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RefundTransactionInfo;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RzdReturnStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RailwayReservationRefundProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List refTransList = (List)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRANS_INFO_LIST);
        boolean isSimulate = Boolean.TRUE.equals(ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_IS_SIMULATE));
        if (CollectionUtil.isEmpty((Collection)refTransList)) {
            return;
        }
        EntityReference agentRef = ProfileHelper.getCurrentUser();
        List<String> ticketNumbers = RailwayReservationRefundProcessor.refundReservation(reservation, refTransList, (EntityReference<Person>)agentRef);
        if (!isSimulate) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0}: \u0431\u0438\u043b\u0435\u0442\u044b {1} \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u044b", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), MiscUtil.join(ticketNumbers, (String)",")}));
        }
    }

    private static List<String> refundReservation(Reservation reservation, List<RefundTransactionInfo> refTransList, EntityReference<Person> agentRef) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (BaseProduct bp : new ArrayList(reservation.getProducts())) {
            RailwayProduct rp;
            if (!(bp instanceof RailwayProduct) || (rp = (RailwayProduct)bp).getStatus() != ProductStatus.SELL || rp.getNextProduct() != null) continue;
            RefundTransactionInfo refTrans = null;
            RefundTransactionInfo.BlankPrice refBlankPrice = null;
            for (RefundTransactionInfo rti : refTransList) {
                refBlankPrice = RailwayReservationRefundProcessor.findBlankPrice(rp, rti);
                if (refBlankPrice == null) continue;
                refTrans = rti;
                break;
            }
            if (refBlankPrice == null || refTrans == null) continue;
            rp.setRefundProcess(false);
            rp.setRefundStan(refTrans.getStan());
            RailwayProduct refProduct = RailwayHelper.refundRailwayProduct(reservation, rp, agentRef, refBlankPrice, refTrans.getRefundDate());
            refProduct.setRefundTransId(refTrans.getRefundTransId());
            refProduct.setExternalRufund(refTrans.isExternalRufund());
            if (refProduct.isExternalRufund() && refProduct.getPaymentType() == PaymentType.CASH) {
                refProduct.setTicketType(TicketType.FAKE);
            }
            result.add(rp.getSystemNumber());
        }
        reservation.setAutoRefundPerformed(true);
        return result;
    }

    private static RefundTransactionInfo.BlankPrice findBlankPrice(RailwayProduct rp, RefundTransactionInfo refTrans) {
        if (refTrans.getStatus() != RzdReturnStatus.SUCCESS) {
            return null;
        }
        String blankId = rp.getBlankId();
        for (RefundTransactionInfo.BlankPrice blankPrice : refTrans.getBlankPrices()) {
            if (!blankId.equals(blankPrice.getBlankId())) continue;
            return blankPrice;
        }
        return null;
    }
}

