/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttribute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttributeEx;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class RzdReservationRefundValidator
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List products = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        if (products.isEmpty()) {
            throw Xeption.forDeveloper((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0443", (Object[])new Object[0]);
        }
        TreeMap<Date, List<RailwayProduct>> allProductsMap = new TreeMap<Date, List<RailwayProduct>>();
        TreeMap<Date, List<RailwayProduct>> selectedProductsMap = new TreeMap<Date, List<RailwayProduct>>();
        for (Reservation relatedReservation : RzdCommonHelper.getRelatedReservations((Reservation)reservation)) {
            BookingStreamHelper.getProductsStream((Reservation)relatedReservation, RailwayProduct.class).forEach(rp -> {
                RailwaySegment seg = Objects.requireNonNull(RzdCommonHelper.getSegment((RailwayProduct)rp));
                Date departureDate = seg.getDepartureDate();
                List allProducts = (List)CollectionUtil.getFromMap((Map)allProductsMap, (Object)departureDate, ArrayList::new);
                List selectedProducts = (List)CollectionUtil.getFromMap((Map)selectedProductsMap, (Object)departureDate, ArrayList::new);
                allProducts.add(rp);
                if (products.contains(rp)) {
                    if (rp.getStatus() == ProductStatus.REFUND || rp.getNextProduct() != null) {
                        throw Xeption.forEndUser((String)"\u0411\u0438\u043b\u0435\u0442 {0} \u0443\u0436\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.", (Object[])new Object[]{rp.getSystemNumber()});
                    }
                    selectedProducts.add(rp);
                }
            });
        }
        selectedProductsMap.forEach((date, selectedProducts) -> {
            if (!selectedProducts.isEmpty()) {
                RailwayProduct firstProduct = (RailwayProduct)selectedProducts.get(0);
                String validateMessage = RzdCommonHelper.getValidateRefundMessage((RailwayProduct)firstProduct);
                if (validateMessage != null) {
                    throw Xeption.forEndUser((String)validateMessage, (Object[])new Object[0]);
                }
                List allProducts = (List)allProductsMap.get(date);
                RailwaySegment segment = Objects.requireNonNull(RzdCommonHelper.getSegment((RailwayProduct)firstProduct));
                boolean allProductsSelected = CollectionUtil.isSameContent((Collection)allProducts, (Collection)selectedProducts);
                if (segment.getSeatsGroupSize() > 1 && !allProductsSelected) {
                    throw Xeption.forEndUser((String)"\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0441\u0435\u0445 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)});
                }
                this.checkProductsAfterRefund(allProducts, (List<RailwayProduct>)selectedProducts);
            }
        });
        this.checkRoundTrip(selectedProductsMap, allProductsMap);
    }

    private void checkProductsAfterRefund(List<RailwayProduct> allProducts, List<RailwayProduct> refundedProducts) {
        RailwaySegment segment = Objects.requireNonNull(RzdCommonHelper.getSegment((RailwayProduct)allProducts.get(0)));
        List effectiveProductAfterRefund = allProducts.stream().filter(RzdCommonHelper::isEffectiveProduct).filter(rp -> !refundedProducts.contains(rp)).collect(Collectors.toList());
        if (effectiveProductAfterRefund.isEmpty()) {
            return;
        }
        int adults = 0;
        int infants = 0;
        for (RailwayProduct rp2 : effectiveProductAfterRefund) {
            List passengerTypes = RailwayProductHelper.getPassengerTypes((RailwayProduct)rp2);
            if (passengerTypes.stream().anyMatch(DictHelper::isAdultPassengerType)) {
                ++adults;
                continue;
            }
            if (passengerTypes.isEmpty() || !passengerTypes.stream().allMatch(DictHelper::isInfantPassengerType)) continue;
            ++infants;
        }
        if (adults == 0) {
            throw Xeption.forEndUser((String)"\u041f\u043e\u0441\u043b\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u043e\u0441\u0442\u0430\u0432\u0430\u0442\u044c\u0441\u044f \u0434\u0435\u0442\u0435\u0439 \u0431\u0435\u0437 \u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445.", (Object[])new Object[0]);
        }
        if (infants > adults) {
            throw Xeption.forEndUser((String)"\u041f\u043e\u0441\u043b\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u0435\u0442\u0435\u0439 \u0431\u0435\u0437 \u043c\u0435\u0441\u0442\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445.", (Object[])new Object[0]);
        }
        Set carriageAttributesEx = CarriageAttributeEx.parseCarriageAttributes((String)segment.getCarrierSubcategory());
        boolean forChild = carriageAttributesEx.stream().anyMatch(attr -> attr.getAttribute() == CarriageAttribute.CHILD);
        if (forChild && infants == 0) {
            throw Xeption.forEndUser((String)"\u0414\u043b\u044f \u043c\u0435\u0441\u0442 \u0434\u0435\u0442\u0441\u043a\u043e\u0439 \u0437\u043e\u043d\u044b \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0435\u0437\u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0431\u0435\u0437 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u043f\u043e \u043f\u043e\u043b\u043d\u043e\u043c\u0443 \u0442\u0430\u0440\u0438\u0444\u0443 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f.", (Object[])new Object[0]);
        }
    }

    private void checkRoundTrip(TreeMap<Date, List<RailwayProduct>> selectedProductsMap, TreeMap<Date, List<RailwayProduct>> allProductsMap) {
        if (allProductsMap.size() != 2) {
            return;
        }
        List<RailwayProduct> selectedForwardProducts = selectedProductsMap.values().iterator().next();
        Iterator<List<RailwayProduct>> allProductsIterator = allProductsMap.values().iterator();
        allProductsIterator.next();
        List<RailwayProduct> allBackProducts = allProductsIterator.next();
        if (selectedForwardProducts.isEmpty()) {
            return;
        }
        if (!RzdCommonHelper.isSapsan((RailwayProduct)selectedForwardProducts.get(0)) || !RzdCommonHelper.isSapsan((RailwayProduct)allBackProducts.get(0))) {
            return;
        }
        for (RailwayProduct forwardProduct : selectedForwardProducts) {
            RailwayProduct product = this.findFirstEffectiveProductByTravellers(allBackProducts, forwardProduct.getPassengers());
            if (product == null) continue;
            throw Xeption.forEndUser((String)"\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 {0} \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u043e\u043a\u0430 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043e\u0431\u0440\u0430\u0442\u043d\u043e\u0433\u043e \u0431\u0438\u043b\u0435\u0442\u0430 {1}", (Object[])new Object[]{forwardProduct.getSystemNumber(), product.getSystemNumber()});
        }
    }

    private RailwayProduct findFirstEffectiveProductByTravellers(List<RailwayProduct> products, List<Traveller> travellers) {
        for (RailwayProduct prod : products) {
            if (!RzdCommonHelper.isEffectiveProduct((RailwayProduct)prod)) continue;
            if (!prod.getPassengers().stream().anyMatch(travellers::contains)) continue;
            return prod;
        }
        return null;
    }
}

