/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.rules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersProperties;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpRailwayProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;

public class RzdGetGdsParametersForReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Boolean proxyTracerEnabled = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED);
        if (proxyTracerEnabled == null) {
            proxyTracerEnabled = Boolean.FALSE;
        }
        RzdParametersActions rzdParametersActions = new RzdParametersActions();
        this.applyRules(rzdParametersActions, rules, salesContext, CommonReservationGdsNameInfoHelper.getRulesGdsName((Reservation)reservation), proxyTracerEnabled);
        this.applyRulesEx(rzdParametersActions, rules, reservation, salesContext, proxyTracerEnabled);
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS, (Object)rzdParametersActions);
    }

    private void applyRules(RzdParametersActions rzdParametersActions, RuleSet rules, SalesContext salesContext, GdsName gds, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RzdParametersProperties(gds, salesContext, proxy));
        proxy.setActionSet((Object)rzdParametersActions);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
    }

    private void applyRulesEx(RzdParametersActions rzdParametersActions, RuleSet rules, Reservation reservation, SalesContext salesContext, boolean proxyTracerEnabled) throws Exception {
        RailwayProduct firstProduct = (RailwayProduct)reservation.getProducts().iterator().next();
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        IbecorpRailwayProductPropertySet props = new IbecorpRailwayProductPropertySet(proxy);
        props.init(firstProduct);
        proxy.setPropertySet((Object)props);
        proxy.setActionSet((Object)rzdParametersActions);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
    }
}

