/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.rules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersProperties;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.searchTrains.RailwayTrainProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class RzdGetGdsParametersForSearchProcessor
extends BaseProcessor {
    private String paramsName;

    public void configure(Map<String, String> parameters) {
        this.paramsName = parameters.get("parameters-name");
    }

    public void process(MessageContext ctx) throws Exception {
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        RzdAbstractSearchParameters params = (RzdAbstractSearchParameters)ctx.getMandatoryObject(this.paramsName);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Boolean proxyTracerEnabled = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED);
        boolean traceEnabled = BooleanUtils.isTrue((Boolean)proxyTracerEnabled);
        RzdTrain train = (RzdTrain)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN);
        RzdParametersActions rzdParametersActions = null;
        if (train == null) {
            rzdParametersActions = this.applyRules(rules, params, salesContext, ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds(), traceEnabled);
        } else {
            EntityReference supplierRef = (EntityReference)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SUPPLIER_REF);
            RzdCategory category = (RzdCategory)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_CATEGORY);
            rzdParametersActions = this.applyRules(rules, train, category, salesContext, (EntityReference<Organization>)supplierRef, traceEnabled);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS, (Object)rzdParametersActions);
    }

    private RzdParametersActions applyRules(RuleSet rules, RzdAbstractSearchParameters params, SalesContext salesContext, GdsName gds, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RzdParametersProperties(params, salesContext, gds, proxy));
        proxy.setActionSet((Object)new RzdParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (RzdParametersActions)proxy.getActionSet();
    }

    private RzdParametersActions applyRules(RuleSet rules, RzdTrain train, RzdCategory category, SalesContext salesContext, EntityReference<Organization> supplier, boolean traceEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!traceEnabled);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        RzdTrainWithCategories rzdTrainWithCategories = new RzdTrainWithCategories();
        rzdTrainWithCategories.setTrain(train);
        rzdTrainWithCategories.getCategories().add(category);
        proxy.setPropertySet((Object)new RailwayTrainProperties(rzdTrainWithCategories, salesContext, null, supplier));
        proxy.setActionSet((Object)new RzdParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (RzdParametersActions)proxy.getActionSet();
    }
}

