/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.rules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersProperties;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;

public class RzdGetGdsParametersSimpleProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Boolean proxyTracerEnabled = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED);
        if (proxyTracerEnabled == null) {
            proxyTracerEnabled = Boolean.FALSE;
        }
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        RzdParametersActions rzdParametersActions = this.applyRules(rules, salesContext, ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds(), proxyTracerEnabled);
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS, (Object)rzdParametersActions);
    }

    private RzdParametersActions applyRules(RuleSet rules, SalesContext salesContext, GdsName gds, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RzdParametersProperties(gds, salesContext, proxy));
        proxy.setActionSet((Object)new RzdParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (RzdParametersActions)proxy.getActionSet();
    }
}

