/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.rules;

import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rzd.ibecorp.BookingTrainRestrictionPolicy;
import com.gridnine.xtrip.common.model.rzd.ibecorp.RzdSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Calendar;
import java.util.Date;

public class RzdPopulateGdsParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference blankOwnerRef = (EntityReference)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_BLANK_OWNER_REF);
        RzdParametersActions actions = (RzdParametersActions)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS);
        RzdGdsParameters gdsParameters = (RzdGdsParameters)ctx.getObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        if (gdsParameters == null) {
            gdsParameters = new RzdGdsParameters();
            ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS, (Object)gdsParameters);
        }
        this.populateGdsParameters(gdsParameters, actions, (EntityReference<Organization>)blankOwnerRef);
    }

    private void populateGdsParameters(RzdGdsParameters parameters, RzdParametersActions actions, EntityReference<Organization> blankOwnerRef) throws Exception {
        if (actions.getDocContentType() != null) {
            parameters.setDocContentType(actions.getDocContentType());
        }
        parameters.setExcludeFromResult(actions.isExcludeFromResult());
        if (parameters.getTicketingPolicy() == null) {
            parameters.setTicketingPolicy(new BookingTrainRestrictionPolicy());
        }
        if (actions.getTravelGroupCheckTime() != null) {
            parameters.getTicketingPolicy().setCheckTime(actions.getTravelGroupCheckTime());
        }
        if (actions.getTravelGroupProductLimit() != null) {
            parameters.getTicketingPolicy().setProductLimit(actions.getTravelGroupProductLimit());
        }
        if (actions.getTravelGroupLockTime() != null) {
            parameters.getTicketingPolicy().setLockTime(actions.getTravelGroupLockTime());
        }
        parameters.getTicketingPolicy().setSubagentNetwork(actions.isTravelGroupSubagentNetwork());
        EntityReference blankOwner = (EntityReference)MiscUtil.guarded(blankOwnerRef, (Object)actions.getBlankOwner());
        if (blankOwner != null) {
            parameters.setBlankOwner(blankOwner);
        }
        RzdSettings settings = (RzdSettings)RzdCommonHelper.getSettingsContainer().getEntity();
        parameters.setCheckBeforeAutocancel(settings.isCheckBeforeAutocancel());
        parameters.setRefundWaitCount(settings.getRefundWaitCount());
        parameters.setRefundWaitSeconds(settings.getRefundWaitSeconds());
        if (parameters.getTimelimit() == null) {
            parameters.setTimelimit(this.getTimeLimit(new Date(), settings.getWaitTime()));
        }
        if (parameters.getDocContentType() == null) {
            parameters.setDocContentType(settings.getDocContentType());
        }
    }

    private Date getTimeLimit(Date date, Integer waitMinutes) throws Exception {
        if (waitMinutes == null) {
            return date;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, waitMinutes);
        return cal.getTime();
    }
}

