/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.searchSchedule;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchWithTimeParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.ScheduleTrain;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;

public class RzdScheduleTrainTimeFilterProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean isSaveRulesTraces;
        RzdSearchWithTimeParameters params = (RzdSearchWithTimeParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_SCHEDULE_PARAMETERS);
        Collection trains = (Collection)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SCHEDULE_TRAINS);
        ScheduleTrain train = (ScheduleTrain)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean bl = isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        if (!this.isValidTime(train, params)) {
            if (isSaveRulesTraces) {
                builder.traceFlightLogic((BaseEntity)train, MessageType.MESSAGE, String.format("train was excluded from result due to time filter: %s not in [%s-%s]", new SimpleDateFormat("HH:mm").format(train.getDepartureDate()), params.getTimeFrom(), params.getTimeTo()));
            }
            trains.remove(train);
            return;
        }
    }

    private boolean isValidTime(ScheduleTrain train, RzdSearchWithTimeParameters params) {
        if (train.getDepartureDate() == null) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(train.getDepartureDate());
        int hours = cal.get(11);
        if (params.getTimeFrom() != null && hours < params.getTimeFrom()) {
            return false;
        }
        return params.getTimeTo() == null || hours <= params.getTimeTo();
    }
}

