/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.searchTrains;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersExPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProxyHelper;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RailwayTrainProperties
implements RzdParametersExPropertiesProvider,
EmployeeCategoriesProvider {
    private static final long serialVersionUID = 4557197226344135595L;
    private final RzdTrainWithCategories train;
    private final Set<String> blankOwners = new HashSet<String>();
    private final Date issueDate;
    private String validatorCode;
    private String salesPoint;
    private final Set<String> departureLocations = new HashSet<String>();
    private final Set<String> arriveLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private final List<String> trainNumbers = new ArrayList<String>();
    private final List<String> carriageTypes = new ArrayList<String>();
    private final List<String> serviceClasses = new ArrayList<String>();
    private final Date departureDate;
    private final Date arrivalDate;
    private final Date departureDateLocal;
    private final Date arrivalDateLocal;
    private final Set<String> fopTypes = new HashSet<String>();
    private final String gdsName;
    private final EntityReference<? extends BaseGdsAccount> gdsAccount;
    private final boolean eticket;
    private BigDecimal totalEquivalentFare;
    private final BigDecimal previousSellTotalEquivalentFare;
    private final TransportationType transportationType;
    private final List<String> trainTypes = new ArrayList<String>();
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private final EntityReference<Person> agent;
    private final EntityReference<Organization> client;
    private final int travelDuration;
    private final String agencyCode;
    private String branchUid;
    private final EntityReference<Organization> supplier;
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final String reservationType;

    public RailwayTrainProperties(RzdTrainWithCategories train, SalesContext salesContext, EntityReference<Organization> blankOwnerRef, EntityReference<Organization> supplierRef) {
        this(train, salesContext, blankOwnerRef, supplierRef, train.getCategories());
    }

    public RailwayTrainProperties(RzdTrainWithCategories train, SalesContext salesContext, EntityReference<Organization> blankOwnerRef, EntityReference<Organization> supplierRef, List<RzdCategory> categories) {
        DictionaryReference arriveStation;
        EntityReference salesPointRef;
        this.train = train;
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        this.agencyCode = CommonHelper.getAgencyCode((SalesContext)salesContext);
        this.reservationType = ReservationType.IBE.name();
        if (blankOwnerCtr != null) {
            Organization blankOwner = (Organization)EntityStorage.get().resolve(blankOwnerRef).getEntity();
            this.blankOwners.clear();
            this.blankOwners.add(blankOwner.getCode());
            this.blankOwners.addAll(blankOwner.getShortName().getValues().values());
            this.blankOwners.addAll(blankOwner.getFullName().getValues().values());
        }
        this.supplier = supplierRef;
        this.issueDate = new Date();
        Validator validator = RzdHelper.findValidator((EntityReference<SalesPoint>)salesContext.getSalesPoint(), (EntityReference<Organization>)salesContext.getAgency(), blankOwnerRef, supplierRef);
        if (validator != null) {
            this.validatorCode = this.getString(validator.getNumber());
        }
        if ((salesPointRef = salesContext.getSalesPoint()) != null) {
            this.salesPoint = salesPointRef.getUid();
        }
        this.departureLocations.clear();
        this.arriveLocations.clear();
        this.visitedCities.clear();
        this.trainNumbers.clear();
        this.carriageTypes.clear();
        this.serviceClasses.clear();
        this.gdsName = this.getEnumName(train.getTrain().getGds());
        this.gdsAccount = train.getTrain().getGdsAccount();
        HashSet<String> geoCodes = new HashSet<String>();
        DictionaryReference departureStation = train.getTrain().getPassengerFrom();
        if (departureStation != null) {
            geoCodes.add(departureStation.getCode());
            geoCodes.addAll(RailwayProxyHelper.collectRailwayStationCodes(geoCodes));
            this.departureLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[0]));
        }
        if ((arriveStation = train.getTrain().getPassengerTo()) != null) {
            geoCodes.clear();
            geoCodes.add(arriveStation.getCode());
            geoCodes.addAll(RailwayProxyHelper.collectRailwayStationCodes(geoCodes));
            this.arriveLocations.addAll(geoCodes);
            this.visitedCities.add(geoCodes.toArray(new String[0]));
        }
        String trainNumber = train.getTrain().getNumber() == null ? null : train.getTrain().getNumber().replaceAll("\\D+$", "");
        this.trainNumbers.add(trainNumber);
        if (!Objects.equals(trainNumber, train.getTrain().getNumber())) {
            this.trainNumbers.add(train.getTrain().getNumber());
        }
        this.departureDate = train.getTrain().getDepartureDatetime();
        this.arrivalDate = train.getTrain().getArrivalDatetime();
        this.departureDateLocal = train.getTrain().getLocalDepartureDatetime();
        this.arrivalDateLocal = train.getTrain().getLocalArrivalDatetime();
        this.eticket = train.getTrain().isERegEnabled();
        this.fopTypes.clear();
        this.fopTypes.add(this.getEnumName(PaymentType.INVOICE));
        BigDecimal minPrice = null;
        for (RzdCategory category : categories) {
            this.carriageTypes.add(this.getEnumName(category.getCarriageType()));
            BigDecimal price = category.getPriceFullMin();
            if (MiscUtil.compare((Comparable)price, minPrice, (boolean)false) >= 0) continue;
            minPrice = price;
        }
        this.trainTypes.clear();
        if (!TextUtil.isBlank((String)train.getTrain().getBrand())) {
            this.trainTypes.add(train.getTrain().getBrand());
        }
        this.totalEquivalentFare = minPrice;
        this.transportationType = RailwayProductHelper.getTransportationType((DictionaryReference)departureStation, (DictionaryReference)arriveStation);
        RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)salesContext.getSubagency());
        this.agent = salesContext.getAgent();
        this.client = salesContext.getClient();
        this.previousSellTotalEquivalentFare = null;
        Integer travelDurationInSec = train.getTrain().getWayTime();
        this.travelDuration = travelDurationInSec != null ? travelDurationInSec : 0;
    }

    public RzdTrainWithCategories getTrain() {
        return this.train;
    }

    public Set<String> getBlankOwners() {
        return this.blankOwners;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getValidatorCode() {
        return this.validatorCode;
    }

    public String getSalesPoint() {
        return this.salesPoint;
    }

    public String getPnr() {
        return null;
    }

    public int getSegmentsAmount() {
        return 1;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public Set<String> getArrivalLocations() {
        return this.arriveLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public List<String> getTrainNumbers() {
        return this.trainNumbers;
    }

    public List<String> getCarriageTypes() {
        return this.carriageTypes;
    }

    public List<String> getServiceClasses() {
        return this.serviceClasses;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public Date getArrivalDate() {
        return this.arrivalDate;
    }

    public Date getArrivalDateLocal() {
        return this.arrivalDateLocal;
    }

    public Date getDepartureDateLocal() {
        return this.departureDateLocal;
    }

    public Set<String> getFopTypes() {
        return this.fopTypes;
    }

    public String getPassengerStatus() {
        return null;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public BigDecimal getTotalEquivalentFare() {
        return this.totalEquivalentFare;
    }

    public void setTotalEquivalentFare(BigDecimal totalEquivalentFare) {
        this.totalEquivalentFare = totalEquivalentFare;
    }

    public BigDecimal getPreviousSellTotalEquivalentFare() {
        return this.previousSellTotalEquivalentFare;
    }

    public List<String> getCarriers() {
        return Collections.emptyList();
    }

    public List<String> getTrainTypes() {
        return this.trainTypes;
    }

    public List<String> getServiceLists() {
        return Collections.emptyList();
    }

    public TransportationType getTransportationType() {
        return this.transportationType;
    }

    public Set<String> getPassengerTypes() {
        return Collections.singleton(DictHelper.getAdultPassengerType().getCode());
    }

    public Set<String> getPassengerTypeCategories() {
        return new HashSet<String>(RulesHelper.getPassengerTypeCategoryCodes((DictionaryReference)DictHelper.getAdultPassengerType()));
    }

    private <E extends Enum<?>> String getEnumName(E value) {
        if (value == null) {
            return null;
        }
        return value.name();
    }

    private String getString(String value) {
        return TextUtil.isBlank((String)value) ? null : value.trim();
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public int getTravelDuration() {
        return this.travelDuration;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public String getBranchUid() {
        return this.branchUid;
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    protected LazyValueHolder<List<EmployeeCategory>> getEmployeeCategoriesHolder() {
        return this.employeeCategories;
    }

    public String getReservationType() {
        return this.reservationType;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public RailwayMcoCategory getRailwayMcoCategory() {
        return null;
    }
}

