/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.searchTrains;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.searchTrains.RailwayTrainProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class RzdBuildTrainProxiesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityReference supplierRef = (EntityReference)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SUPPLIER_REF);
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection trains = (Collection)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_LIST);
        Boolean proxyTracerEnabled = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED);
        boolean traceEnabled = BooleanUtils.isTrue((Boolean)proxyTracerEnabled);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        List proxies = trains.stream().map(ExceptionUtil.wrapFunction(train -> this.applyRules(rules, (RzdTrainWithCategories)train, salesContext, (EntityReference<Organization>)supplierRef, traceEnabled, isSaveRulesTraces, (GdsTracingItemBuilder<RzdTrainWithCategories>)builder))).collect(Collectors.toList());
        ctx.putObject((Enum)IBusGdsContextKeys.RULE_PROXIES, proxies);
    }

    private RuleProxy<RailwayTrainProperties, RzdParametersActions> applyRules(RuleSet rules, RzdTrainWithCategories train, SalesContext salesContext, EntityReference<Organization> supplier, boolean proxyTracerEnabled, boolean isSaveRulesTraces, GdsTracingItemBuilder<RzdTrainWithCategories> builder) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RailwayTrainProperties(train, salesContext, null, supplier));
        proxy.setActionSet((Object)new RzdParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        if (isSaveRulesTraces) {
            for (String ruleUid : proxy.getAppliedRules()) {
                RuleSettings rs = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                if (rs == null) continue;
                builder.traceFlightLogic((BaseEntity)train, MessageType.MESSAGE, String.format("rule %s was applied: %s", rs.getName(), rs.getRestrictionsInfoNoHtml()));
            }
        }
        return proxy;
    }
}

