/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.searchTrains;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.GdsTracingTrainItemBuilder;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RzdTrainAddBookingCommissionProcessor
extends BaseProcessor {
    private static final String TRACE_DOC_PART_NAME = "commission-calculator";

    public void process(MessageContext ctx) throws Exception {
        List trains = (List)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_LIST);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        GdsTracingDocument document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean toTrace = document != null && gdsTracingSettings != null && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingTrainItemBuilder tracingBuilder = new GdsTracingTrainItemBuilder();
        if (toTrace) {
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            StringBuilder traceBuilder = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            ObjectTrace.trace((Appendable)sb, (Object)salesContext);
            String msg = String.format("calculating commissions for sales context\r\n%s\r\n", sb);
            traceBuilder.append(msg);
            tracingBuilder.traceGlobalLogic(traceBuilder.toString());
        }
        for (RzdTrainWithCategories trainEx : trains) {
            for (RzdCategory category : trainEx.getCategories()) {
                String resUid = RailwayHelper.generateReservationUid(trainEx.getUid(), category.getUid());
                Reservation res = (Reservation)CollectionUtil.find((Iterable)((BookingFile)bookingCtr.getEntity()).getReservations(), (String)resUid);
                RailwayProduct product = Objects.requireNonNull(RzdCommonHelper.getProduct((Reservation)res));
                XtripPriceStructure priceStructure = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)product, (boolean)false);
                BigDecimal gdsPriceMin = category.getPriceOriginalMin();
                if (gdsPriceMin != null) {
                    BigDecimal fare = priceStructure.getProductPrice();
                    BigDecimal total = priceStructure.getTotal();
                    category.setPriceOriginalMin(fare);
                    category.setPriceFullMin(total);
                }
                if (!toTrace) continue;
                GeneralProductContractRelationData clientCR = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
                String currencyCode = clientCR.getGeneralData().getCurrency().getCode();
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("\n\u0412\u0430\u0433\u043e\u043d %s\n", category.getCarriageType()));
                List<AppliedRule> appliedRules = this.getProductAppliedRules(product.getUid(), (BookingFile)bookingCtr.getEntity());
                this.traceAppliedRules(sb, appliedRules);
                sb.append(String.format("\u0426\u0435\u043d\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f = %s\n", gdsPriceMin));
                sb.append(String.format("\u0422\u0430\u0440\u0438\u0444 = %s %s\n", category.getPriceOriginalMin(), currencyCode));
                sb.append(String.format("\u0418\u0442\u043e\u0433\u043e \u0441\u043e \u0441\u0431\u043e\u0440\u0430\u043c\u0438 = %s %s\n", category.getPriceFullMin(), currencyCode));
                tracingBuilder.traceFlightLogic((BaseEntity)trainEx, MessageType.MESSAGE, sb.toString());
            }
        }
        if (toTrace) {
            document.getParts().add(tracingBuilder.buildGdsTracingDocumentPart(TRACE_DOC_PART_NAME));
        }
    }

    private void traceAppliedRules(StringBuilder sb, List<AppliedRule> appliedRules) {
        for (AppliedRule ar : appliedRules) {
            sb.append(String.format("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 %s, \u043f\u0440\u0430\u0432\u0438\u043b\u043e %s, \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: %s\n", ar.getContract(), ar.getRuleName(), ar.getRuleDescription()));
        }
    }

    private List<AppliedRule> getProductAppliedRules(String productUid, BookingFile bf) {
        if (TextUtil.isBlank((String)productUid)) {
            return Collections.emptyList();
        }
        ArrayList<AppliedRule> result = new ArrayList<AppliedRule>();
        for (AppliedRule ar : bf.getAppliedRules()) {
            if (!productUid.equals(ar.getProductUid())) continue;
            result.add(ar);
        }
        return result;
    }
}

