/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.searchTrains;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Iterator;

public class TrainFilter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Collection trains = (Collection)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_LIST);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        Iterator iter = trains.iterator();
        while (iter.hasNext()) {
            RzdTrainWithCategories train = (RzdTrainWithCategories)iter.next();
            String mes = this.checkDeparture(train);
            if (TextUtil.nonBlank((String)mes)) {
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)train, MessageType.MESSAGE, mes);
                }
                iter.remove();
                continue;
            }
            mes = this.checkArrival(train);
            if (!TextUtil.nonBlank((String)mes)) continue;
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)train, MessageType.MESSAGE, mes);
            }
            iter.remove();
        }
    }

    private String checkDeparture(RzdTrainWithCategories train) {
        if (train.getTrain().getPassengerFrom() == null) {
            return String.format("\u041f\u043e\u0435\u0437\u0434 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0432\u044b\u0434\u0430\u0447\u0438, \u0442\u0430\u043a \u043a\u0430\u043a \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f %s \u043d\u0435\u0442 \u0432 \u0441\u043b\u043e\u0432\u0430\u0440\u0435", train.getTrain().getDeparture());
        }
        return null;
    }

    private String checkArrival(RzdTrainWithCategories train) {
        if (train.getTrain().getPassengerTo() == null) {
            return String.format("\u041f\u043e\u0435\u0437\u0434 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0432\u044b\u0434\u0430\u0447\u0438, \u0442\u0430\u043a \u043a\u0430\u043a \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f %s \u043d\u0435\u0442 \u0432 \u0441\u043b\u043e\u0432\u0430\u0440\u0435", train.getTrain().getArrival());
        }
        return null;
    }
}

