/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.setEReg;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.IERegBlankInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class RzdReservationERegProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List blanks;
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List<String> ticketNumbers = this.updateEReg(reservation, blanks = (List)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_EREG_BLANKS));
        if (!ticketNumbers.isEmpty()) {
            ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_EREG_WAS_CHANGED, (Object)(!ticketNumbers.isEmpty() ? 1 : 0));
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430 \u042d\u0420: {1}", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), MiscUtil.join(ticketNumbers, (String)",")}));
        }
    }

    private List<String> updateEReg(Reservation reservation, List<? extends IERegBlankInfo> blanks) throws Exception {
        ArrayList<String> ticketNumbers = new ArrayList<String>();
        for (BaseProduct bp : reservation.getProducts()) {
            RailwayProduct rp;
            IERegBlankInfo blank;
            if (!(bp instanceof RailwayProduct) || (blank = this.findBlank(blanks, (rp = (RailwayProduct)bp).getBlankId())) == null || rp.getStatus() != ProductStatus.SELL || rp.getNextProduct() != null || !RailwayHelper.updateEReg(rp, blank.isHasEReg())) continue;
            ticketNumbers.add(rp.getSystemNumber());
        }
        return ticketNumbers;
    }

    private IERegBlankInfo findBlank(List<? extends IERegBlankInfo> blanks, String blankId) {
        if (blankId == null) {
            return null;
        }
        for (IERegBlankInfo iERegBlankInfo : blanks) {
            if (!blankId.equals(iERegBlankInfo.getBlankId())) continue;
            return iERegBlankInfo;
        }
        return null;
    }
}

