/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.ticketReservation.RzdReservationTicketingParamsProvider;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.BlankTicketNumberProvider;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class RzdReservationTicketingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        PaymentType paymentType = (PaymentType)ctx.getObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        RzdReservationTicketingParamsProvider params = (RzdReservationTicketingParamsProvider)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKET_RESERVATION_PARAMETERS);
        this.issueReservation(reservation, params, paymentType);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043e", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKETED, (Object)Boolean.TRUE);
    }

    private void issueReservation(Reservation reservation, RzdReservationTicketingParamsProvider ticketParams, PaymentType paymentType) throws Exception {
        Date curDate = new Date();
        for (BlankTicketNumberProvider blankTicketNumberProvider : ticketParams.getTicketNumbers()) {
            RailwayProduct rp = RzdCommonHelper.getProductByBlankId((Reservation)reservation, (String)blankTicketNumberProvider.getBlankId());
            if (rp == null) {
                throw Xeption.forDeveloper((String)"can't find railway product with blankId {0}", (Object[])new Object[]{blankTicketNumberProvider.getBlankId()});
            }
            rp.setSystemNumber(blankTicketNumberProvider.getTicketNumber());
            rp.setStatus(ProductStatus.SELL);
            rp.setIssueDate(curDate);
            rp.setEndorsement(ticketParams.getOrderNumber());
            rp.setRefundExpireDate((Date)MiscUtil.guarded((Object)blankTicketNumberProvider.getRefundExpireDate(), (Object)ticketParams.getRefundExpireDate()));
            rp.setERegExpireDate(ticketParams.getERegChangeExpireDate());
            if (paymentType != null) {
                rp.setPaymentType(paymentType);
            }
            RailwayHelper.updateEReg(rp, blankTicketNumberProvider.isHasEReg());
            RailwayProductHelper.updateFops((RailwayProduct)rp);
        }
    }
}

