/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rzd.ibecorp.BookingTrainRestrictionPolicy;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;

public class RzdReservationTicketingValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdGdsParameters gdsParameters = (RzdGdsParameters)ctx.getObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        if (!RzdReservationTicketingValidator.checkTicketingPolicy((BookingFile)bookingCtr.getEntity(), gdsParameters)) {
            String pnrs = RzdCommonHelper.getRecordLocators((BookingFile)((BookingFile)bookingCtr.getEntity()));
            throw Xeption.forEndUser((String)String.format("\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 '%s': \u043f\u0440\u043e\u0434\u0430\u0436\u0430 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0445 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u0447\u0435\u0440\u0435\u0437 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430.", pnrs), (Object[])new Object[0]);
        }
    }

    public static boolean checkTicketingPolicy(BookingFile bf, RzdGdsParameters gdsParameters) throws Exception {
        BookingTrainRestrictionPolicy ticketingPolicy = gdsParameters.getTicketingPolicy();
        if (ticketingPolicy == null) {
            return true;
        }
        Reservation firstRes = RzdCommonHelper.getFirstReservation((BookingFile)bf);
        RailwaySegment segment = RzdCommonHelper.getSegment((Reservation)firstRes);
        String trainNumber = segment.getTrainNumber();
        Date departureDate = segment.getDepartureDate();
        String routeLine = RailwayProductHelper.getRouteString((RailwayProduct)RzdCommonHelper.getProduct((Reservation)firstRes));
        int productCount = 0;
        for (Reservation res : RzdCommonHelper.getReservations((BookingFile)bf)) {
            productCount += res.getProducts().size();
        }
        if (ticketingPolicy.getProductLimit() == null) {
            return true;
        }
        if (productCount > ticketingPolicy.getProductLimit()) {
            return false;
        }
        List<RailwayProductIndex> indexes = RzdReservationTicketingValidator.getRailwayProductIndexes((EntityReference<Organization>)firstRes.getSubagency(), (EntityReference<Organization>)(ticketingPolicy.isSubagentNetwork() ? null : bf.getCustomerProfile()), trainNumber, departureDate, routeLine);
        boolean result = RzdReservationTicketingValidator.checkTicketingPolicy(productCount, new Date(), indexes, ticketingPolicy);
        return result;
    }

    public static boolean checkTicketingPolicy(int productCount, Date checkDate, List<RailwayProductIndex> indexes, BookingTrainRestrictionPolicy ticketingPolicy) {
        boolean wasLock;
        if (indexes.isEmpty() || ticketingPolicy == null) {
            return true;
        }
        Integer checkMinutes = ticketingPolicy.getCheckTime();
        Integer productLimit = ticketingPolicy.getProductLimit();
        Integer lockMinutes = ticketingPolicy.getLockTime();
        if (checkMinutes == null || productLimit == null || lockMinutes == null || checkMinutes == 0) {
            return true;
        }
        Date lastProductDate = indexes.get(0).getIssueDate();
        int count = RzdReservationTicketingValidator.calcProductCount(indexes, lastProductDate, checkMinutes);
        boolean bl = wasLock = count >= productLimit;
        if (wasLock) {
            return checkDate.after(MiscUtil.addMinutesToDate((Date)lastProductDate, (int)lockMinutes));
        }
        count = RzdReservationTicketingValidator.calcProductCount(indexes, checkDate, checkMinutes);
        return count + productCount <= productLimit;
    }

    private static int calcProductCount(List<RailwayProductIndex> indexes, Date lastDate, int checkMinutes) {
        int result = 0;
        Date firstDate = MiscUtil.addMinutesToDate((Date)lastDate, (int)(-checkMinutes));
        for (RailwayProductIndex idx : indexes) {
            Date date = idx.getIssueDate();
            if (!MiscUtil.isBetween((Date)MiscUtil.getBeforeTime((Date)firstDate), (Date)MiscUtil.setAfterTime((Date)lastDate), (Date)date)) continue;
            ++result;
        }
        return result;
    }

    private static List<RailwayProductIndex> getRailwayProductIndexes(EntityReference<Organization> subagencyRef, EntityReference<Organization> clientRef, String trainNumber, Date departureDate, String routeLine) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)RailwayProductIndex.Property.issueDate.name(), (Object)MiscUtil.clearTime((Date)MiscUtil.addDaysToDate((Date)new Date(), (int)-1))));
        if (subagencyRef != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.subagency.name(), subagencyRef));
        }
        if (clientRef != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.client.name(), clientRef));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.containsOnly((String)RailwayProductIndex.Property.trainNumbers.name(), (String)trainNumber));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.routeLine.name(), (Object)routeLine));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.departureDate.name(), (Object)departureDate));
        query.getPreferredProperties().add(RailwayProductIndex.Property.issueDate.name());
        query.getPreferredProperties().add(RailwayProductIndex.Property.systemNumber.name());
        query.getCriteria().getOrders().put(RailwayProductIndex.Property.issueDate.name(), SortOrder.DESC);
        List result = EntityStorage.get().search(RailwayProductIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        return result;
    }
}

