/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.common.traveldocs;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RzdReservationTravelDocsDeleteProcessor
extends BaseProcessor {
    private static final List<DocumentType> defaultDocumentTypes = Arrays.asList(DocumentType.TRAVELDOCUMENT, DocumentType.MCO_DOCUMENT);
    private final List<DocumentType> documentTypes = new ArrayList<DocumentType>();

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        String docTypes = parameters.get("document-types");
        if (TextUtil.isBlank((String)docTypes)) {
            this.documentTypes.addAll(defaultDocumentTypes);
        } else {
            for (String name : docTypes.split(",")) {
                this.documentTypes.add(DocumentType.valueOf((String)name));
            }
        }
    }

    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List relatedReservations = RzdCommonHelper.getRelatedReservations((Reservation)reservation);
        ArrayList<String> uids = new ArrayList<String>();
        for (Reservation res : relatedReservations) {
            uids.add(res.getUid());
            uids.addAll(res.getProducts().stream().map(bp -> bp.getUid()).collect(Collectors.toList()));
        }
        List<BasicDocumentIndex> docIndexes = RzdReservationTravelDocsDeleteProcessor.getBookingDocuments((EntityReference<BookingFile>)bookingCtr.toReference(), this.documentTypes);
        for (BasicDocumentIndex idx : docIndexes) {
            if (!uids.contains(idx.getNavigationKey())) continue;
            EntityStorage.get().delete(EntityStorage.get().resolve(idx.getSource()));
        }
    }

    private static List<BasicDocumentIndex> getBookingDocuments(EntityReference<BookingFile> bookingRef, List<DocumentType> documentTypes) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), bookingRef));
        SearchCriterion[] docTypesCriterions = new SearchCriterion[documentTypes.size()];
        int i = 0;
        for (DocumentType docType : documentTypes) {
            docTypesCriterions[i++] = SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)docType);
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])docTypesCriterions));
        query.getPreferredProperties().add(BasicDocumentIndex.Property.name.name());
        List result = EntityStorage.get().search(BasicDocumentIndex.class, query).getData();
        return result;
    }
}

