/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im;

import com.gridnine.xtrip.common.ibecorp.exception.NeedSetErrorBookingStatusException;
import com.gridnine.xtrip.common.ibecorp.exception.NoSeatsException;
import com.gridnine.xtrip.common.ibecorp.exception.TicketsAlreadyRefundedException;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.exceptions.UserBookingRejectException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMGateResponseProcessor;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMErrorResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class IMErrorTranslator {
    private static final List<String> IGNORE_MESSAGES = Collections.singletonList("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0443\u0441\u043b\u0443\u0433");
    private static final Map<String, String> CODE_MESSAGES_MAP = new HashMap<String, String>();
    private static final Map<String, String> TEXT_MESSAGES_MAP = new HashMap<String, String>();
    private static final Map<Pattern, Xeption> MESSAGE_XEPTIONS;

    IMErrorTranslator() {
    }

    static void translateError(IMErrorResponse response) {
        if (response != null) {
            Xeption xeption;
            String translated = CODE_MESSAGES_MAP.get(response.getCode());
            if (translated != null) {
                throw Xeption.forEndUser((String)translated, (Object[])new Object[0]);
            }
            LinkedHashSet<String> messages = new LinkedHashSet<String>();
            messages.add(response.getMessage());
            if (CollectionUtil.isNotEmpty(response.getMessageParams())) {
                messages.removeIf(IGNORE_MESSAGES::contains);
                messages.addAll(response.getMessageParams());
            }
            messages.add(response.getProviderError());
            messages.removeIf(TextUtil::isBlank);
            translated = messages.stream().map(TEXT_MESSAGES_MAP::get).map(x$0 -> L10nResourcesManager.getStr((String)x$0, (Object[])new Object[0])).filter(TextUtil::nonBlank).collect(Collectors.joining("\n"));
            if (TextUtil.isBlank((String)translated)) {
                translated = String.join((CharSequence)"\n", messages);
            }
            if ((xeption = IMErrorTranslator.findMatchesXeption(translated)) != null) {
                throw xeption;
            }
            throw Xeption.forEndUser((String)translated, (Object[])new Object[0]);
        }
    }

    private static Xeption findMatchesXeption(String text) {
        if (TextUtil.isBlank((String)text)) {
            return null;
        }
        for (Map.Entry<Pattern, Xeption> entry : MESSAGE_XEPTIONS.entrySet()) {
            Matcher m = entry.getKey().matcher(text);
            if (!m.find()) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String s = "{\n  \"ProviderError\": \"US330: \u041d\u0415\u0414\u041e\u041f\u0423\u0421\u0422\u0418\u041c\u042b\u0419 \u041d\u041e\u041c\u0415\u0420 \u041a\u0410\u0420\u0422\u042b\",\n  \"Code\": 3,\n  \"Message\": \"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0443\u0441\u043b\u0443\u0433\",\n  \"MessageParams\": [\n    \"US330: \u041d\u0415\u0414\u041e\u041f\u0423\u0421\u0422\u0418\u041c\u042b\u0419 \u041d\u041e\u041c\u0415\u0420 \u041a\u0410\u0420\u0422\u042b\"\n  ]\n}";
        IMErrorResponse response = (IMErrorResponse)IMGateResponseProcessor.MAPPER.readValue(s.getBytes(), IMErrorResponse.class);
        System.out.println(response.getMessage());
        IMErrorTranslator.translateError(response);
    }

    static {
        CODE_MESSAGES_MAP.put("122", "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430");
        CODE_MESSAGES_MAP.put("329", "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430\u044f \u043a\u043e\u043c\u0431\u0438\u043d\u0430\u0446\u0438\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u043a\u0443\u043f\u043a\u0430 \u043e\u0434\u043d\u0438\u043c \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u043c \u0446\u0435\u043b\u043e\u0433\u043e \u043a\u0443\u043f\u0435.");
        TEXT_MESSAGES_MAP.put("\u0412 \u0424\u0418\u041e \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0410 BCE \u0411\u0423\u041a\u0412\u042b \u0414.\u0411. \u041b\u0410\u0422\u0418\u041d\u0421\u041a\u0418\u041c\u0418", "\u0424\u0418\u041e \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b \u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u043c\u0438 \u0431\u0443\u043a\u0432\u0430\u043c\u0438");
        TEXT_MESSAGES_MAP.put("\u041f\u0415\u0420\u0415\u0421\u0415\u0427\u0415\u041d\u0418\u0415 \u0413\u0420\u0410\u041d\u0418\u0426\u042b \u0420\u041e\u0421\u0421\u0418\u042f-\u0411\u0415\u041b\u0410\u0420\u0423\u0421\u042c \u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d\u041e \u0422\u041e\u041b\u042c\u041a\u041e \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0410\u041c \u0421 \u0413\u0420\u0410\u0416\u0414\u0410\u041d\u0421\u0422\u0412\u041e\u041c RUS \u0418\u041b\u0418 BLR", "RAILWAY_MESSAGE_NON_RUS_OR_BLR_CITIZENSHIP_UNACCEPTABLE");
        MESSAGE_XEPTIONS = new HashMap<Pattern, Xeption>();
        MESSAGE_XEPTIONS.put(Pattern.compile("\u0412\u041e\u0417\u0412\u0420\u0410\u0422 \u0412\u0421\u0415\u0413\u041e \u0417\u0410\u041a\u0410\u0417\u0410 \u041d\u0415 \u0412\u041e\u0417\u041c\u041e\u0416\u0415\u041d", 16), (Xeption)new NeedSetErrorBookingStatusException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e: \u0412\u041e\u0417\u0412\u0420\u0410\u0422 \u0412\u0421\u0415\u0413\u041e \u0417\u0410\u041a\u0410\u0417\u0410 \u041d\u0415 \u0412\u041e\u0417\u041c\u041e\u0416\u0415\u041d"));
        MESSAGE_XEPTIONS.put(Pattern.compile("\u041d\u0435\u0442 \u043c\u0435\u0441\u0442 \u043f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f\u043c", 16), (Xeption)new NoSeatsException());
        MESSAGE_XEPTIONS.put(Pattern.compile("\u0412 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u043c \u0432\u0430\u0433\u043e\u043d\u0435 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u043c\u0435\u0441\u0442 \u043d\u0435\u0442", 16), (Xeption)new NoSeatsException());
        MESSAGE_XEPTIONS.put(Pattern.compile("\u041d\u0430 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438 (\u0438\u043b\u0438 \u043f\u043e\u0435\u0437\u0434\u0435) \u043c\u0435\u0441\u0442 \u043d\u0435\u0442", 16), (Xeption)new NoSeatsException());
        MESSAGE_XEPTIONS.put(Pattern.compile("\u0423\u041a\u0410\u0417\u0410\u041d \u041d\u041e\u041c\u0415\u0420 \u041f\u0410\u0421\u041f\u041e\u0420\u0422\u0410, \u041a\u041e\u0422\u041e\u0420\u042b\u0419 \u041d\u0415 \u0417\u0410\u0420\u0415\u0413\u0418\u0421\u0422\u0420\u0418\u0420\u041e\u0412\u0410\u041d \u041f\u041e \u0414\u0410\u041d\u041d\u041e\u0419 KAPTE"), (Xeption)new UserBookingRejectException("RAILWAY_MESSAGE_PASSPORT_NUMBER_NOT_MATCH_BONUS_CARD", new Object[0]));
        MESSAGE_XEPTIONS.put(Pattern.compile("\u041d\u0415\u0414\u041e\u041f\u0423\u0421\u0422\u0418\u041c\u042b\u0419 \u041d\u041e\u041c\u0415\u0420 \u0411\u041e\u041d\u0423\u0421\u041d\u041e\u0419 \u041a\u0410\u0420\u0422\u042b"), (Xeption)new UserBookingRejectException("RAILWAY_MESSAGE_INVALID_NUMBER_OF_BONUS_CARDS", new Object[0]));
        MESSAGE_XEPTIONS.put(Pattern.compile("\u041d\u0415\u0414\u041e\u041f\u0423\u0421\u0422\u0418\u041c\u042b\u0419 \u041d\u041e\u041c\u0415\u0420 \u041a\u0410\u0420\u0422\u042b"), (Xeption)new UserBookingRejectException("RAILWAY_MESSAGE_INVALID_NUMBER_OF_BONUS_CARDS", new Object[0]));
        MESSAGE_XEPTIONS.put(Pattern.compile("\u041f\u0420\u041e\u0415\u0417\u0414 \u0412 \u0414\u0410\u041d\u041d\u041e\u041c \u0421\u041e\u041e\u0411\u0429\u0415\u041d\u0418\u0418 \u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d \u0422\u041e\u041b\u042c\u041a\u041e \u0413\u0420\u0410\u0416\u0414\u0410\u041d\u0410\u041c [\u0421C][\u0422T][\u0420P][\u0410A][\u041dH] \u041e\u0422\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u042f \u0418 \u041d\u0410\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u042f"), (Xeption)new UserBookingRejectException("RAILWAY_MESSAGE_CITIZENSHIP_UNACCEPTABLE", new Object[0]));
        MESSAGE_XEPTIONS.put(Pattern.compile("\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0431\u043b\u0430\u043d\u043a\u0438 .*\u0431\u044b\u043b\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u044b"), (Xeption)new TicketsAlreadyRefundedException());
    }
}

