/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.InMobGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRequestParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.nimbusds.jose.util.StandardCharset;

public class IMGateRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IMRequestParameters imParams = (IMRequestParameters)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_REQUEST_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        InMobGdsAccount gdsAccount = (InMobGdsAccount)accountCtr.getEntity();
        if (gdsAccount.getAddress() == null) {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d URL", (Object[])new Object[0]);
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(gdsAccount.getAddress() + "/" + imParams.getUrl());
        if (imParams.getRequestData() != null) {
            String request = new ObjectMapper().writeValueAsString((Object)imParams.getRequestData());
            httpRequest.setBody(request.getBytes(StandardCharset.UTF_8));
        }
        httpRequest.setRequestMethod(imParams.getUrlSuffix().getMethod());
        httpRequest.getRequestProperties().put((Object)"Connection", (Object)"close");
        String userPassword = gdsAccount.getAccount() + ":" + gdsAccount.getPassword();
        httpRequest.getRequestProperties().put((Object)"Authorization", (Object)("Basic " + Base64.encode((byte[])userPassword.getBytes())));
        httpRequest.getRequestProperties().put((Object)"Content-Type", (Object)"application/json;charset=UTF-8");
        httpRequest.getRequestProperties().put((Object)"Content-Encoding", (Object)"application/gzip");
        httpRequest.getRequestProperties().put((Object)"POS", (Object)gdsAccount.getTerminal());
        httpRequest.setReadTimeout(Integer.valueOf(180000));
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(true);
        httpRequest.setUseSsl(true);
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_OPERATION, (Object)imParams.getUrlSuffix().getValue());
    }
}

