/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMErrorTranslator;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMUrlSuffix;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMErrorResponse;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMResponse;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import java.nio.charset.StandardCharsets;

public class IMGateResponseProcessor
extends BaseProcessor {
    static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public void process(MessageContext ctx) throws Exception {
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        IMRequestParameters imParams = (IMRequestParameters)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_REQUEST_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        if (httpResponse == null) {
            throw Xeption.forDeveloper((String)"HttpResponse is null.", (Object[])new Object[0]);
        }
        if (imParams == null) {
            throw Xeption.forDeveloper((String)"RequestParameters is null.", (Object[])new Object[0]);
        }
        if (httpResponse.getResponseCode() != 200) {
            switch (httpResponse.getResponseCode()) {
                case 500: {
                    byte[] error = httpResponse.getError();
                    IMErrorResponse response = null;
                    try {
                        response = (IMErrorResponse)MAPPER.readValue(error, IMErrorResponse.class);
                    }
                    catch (Exception e) {
                        throw Xeption.forDeveloper((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f Internal Server Error: {0}", (Object[])new Object[]{new String(error)});
                    }
                    IMErrorTranslator.translateError(response);
                }
                case 401: {
                    throw Xeption.forAdmin((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}.", (Object[])new Object[]{accountCtr.toReference().getCaption()});
                }
                case 502: {
                    throw Xeption.forAdmin((String)"\u041e\u0442\u0432\u0435\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f: 502 \u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439 \u0448\u043b\u044e\u0437, Bad Gateway", (Object[])new Object[0]);
                }
            }
            throw Xeption.forDeveloper((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f '{0}'/'{1}' ({2}). \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441.", (Object[])new Object[]{httpResponse.getError() == null ? "" : new String(httpResponse.getError(), StandardCharsets.UTF_8), httpResponse.getResponseMessage(), httpResponse.getResponseCode()});
        }
        if (imParams.getUrlSuffix().getResponseClass() != null) {
            ctx.putObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA, (Object)this.buildResponse(httpResponse, imParams.getUrlSuffix()));
        } else {
            ctx.putObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA, (Object)httpResponse.getBody());
        }
    }

    private IMResponse buildResponse(HttpResponse response, IMUrlSuffix suffix) throws Exception {
        return (IMResponse)MAPPER.readValue(response.getBody(), suffix.getResponseClass());
    }
}

