/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im;

import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarPlaceType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.KupeIndication;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBonusCardType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPriceValues;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.HandBaggageType;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeHandBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeLuggageInRailwayRoomParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeePetBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.BookingConverterHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.BaseCarriage;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Carriage;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.MainServiceReference;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.ServiceReturnRequest;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.VatRateValue;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.VatRateValuesProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.baggage.BaggageRequest;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.baggage.RailwayAnimalTransportationRequest;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.baggage.RailwayExtraHandLuggageRequest;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.baggage.RailwayLuggageInBaggageRoomRequest;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RefundTransactionInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IMHelper {
    private static final Map<CarriageType, String> carriageTypeMap = new HashMap<CarriageType, String>();
    private static final Map<RzdTariff, String> tariffsMap = new HashMap<RzdTariff, String>();
    private static final Map<CompartmentType, String> compartmentTypeMap = new HashMap<CompartmentType, String>();
    private static final Map<KupeIndication, String> kupeIndicationMap = new HashMap<KupeIndication, String>();
    private static final Map<PassportType, String> passportTypeMap = new HashMap<PassportType, String>();
    private static final Map<Gender, String> genderMap = new HashMap<Gender, String>();
    private static final Map<String, RzdStatus> rzdStatusMap = new HashMap<String, RzdStatus>();
    private static final Map<PassengerTypeValue, String> passengerTypeMap = new HashMap<PassengerTypeValue, String>();
    private static final Map<String, CarPlaceType> carPlaceTypeMap = new HashMap<String, CarPlaceType>();
    private static final Map<String, RailwayMcoCategory> mcoCategoriesMap;
    private static final Map<String, RailwayMcoCategory> mcoCategoriesByTypeMap;
    private static final Map<String, RzdBonusCardType> bonusCardTypesMap;
    private static final Map<HandBaggageType, String> handBaggageTypesMap;
    private static final String MEAL_GDS_ID_SEPARATOR = "/";
    private static final String BANK_CARD = "Card";
    private static final String CASH = "Cash";
    private static final String YANDEX_MONEY = "YandexMoney";

    public static CarPlaceType convertCarPlaceTypeFromGds(String carPlaceType) {
        CarPlaceType result = carPlaceTypeMap.get(carPlaceType);
        if (result == null) {
            IncidentsLog.reportStackTrace((String)("Missing service class with code: " + carPlaceType));
            return CarPlaceType.UNDEFINED;
        }
        return result;
    }

    public static String convertGenderToGds(Gender value) {
        return genderMap.get(value);
    }

    public static String convertPassportTypeToGds(PassportType value, DictionaryReference<Country> countryRef) {
        PassportType correctedValue = value;
        if (correctedValue == PassportType.BIRTHDAY_NOTIFICATION && RzdCommonHelper.isKzCitizenship(countryRef)) {
            correctedValue = PassportType.PASSPORT;
        }
        return passportTypeMap.get(correctedValue);
    }

    public static PassportType convertPassportTypeFromGds(String gdsValue) {
        return (PassportType)CollectionUtil.getKeyByValue(passportTypeMap, (Object)gdsValue);
    }

    public static String convertKupeIndicationToGds(KupeIndication value) {
        if (value == null) {
            return kupeIndicationMap.get(KupeIndication.ANY);
        }
        return kupeIndicationMap.get(value);
    }

    public static String convertCompartmentTypeToGds(CompartmentType ct) {
        return compartmentTypeMap.get(ct) == null ? "NoValue" : compartmentTypeMap.get(ct);
    }

    public static CompartmentType convertCompartmentTypeFromGds(String gdsValue) {
        return (CompartmentType)CollectionUtil.getKeyByValue(compartmentTypeMap, (Object)gdsValue);
    }

    public static RzdStatus convertStatusFromGds(String status) {
        return rzdStatusMap.get(status);
    }

    public static String convertCarriageTypeToGds(CarriageType ct) {
        return carriageTypeMap.get(ct);
    }

    public static CarriageType convertCarriageTypeFromGds(String text) {
        if (TextUtil.isBlank((String)text)) {
            return null;
        }
        return (CarriageType)CollectionUtil.getKeyByValue(carriageTypeMap, (Object)text);
    }

    public static RzdTariff convertGdsTariffTypeToRzdTariff(String gdsValue) {
        return (RzdTariff)CollectionUtil.getKeyByValue(tariffsMap, (Object)gdsValue);
    }

    public static String convertRzdTariffToGdsTariffType(RzdTariff tariff) {
        return tariffsMap.get(tariff);
    }

    public static RailwayMcoCategory convertMcoCategoryFromGds(String gdsValue) {
        return mcoCategoriesMap.get(gdsValue);
    }

    public static RailwayMcoCategory convertMcoCategoryByTypeFromGds(String gdsValue) {
        return mcoCategoriesByTypeMap.get(gdsValue);
    }

    public static RzdBonusCardType convertBonusCardTypeFromGds(String gdsValue) {
        return bonusCardTypesMap.get(gdsValue);
    }

    public static String convertBonusCardTypeToGds(RzdBonusCardType value) {
        return (String)CollectionUtil.getKeyByValue(bonusCardTypesMap, (Object)value);
    }

    public static String convertHandBaggageTypeToGds(HandBaggageType value) {
        return handBaggageTypesMap.get(value);
    }

    public static String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(date);
    }

    public static String formatDateDay(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'00:00:00").format(date);
    }

    private static Date formatDate(String date) throws ParseException {
        if (TextUtil.isBlank((String)date)) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(date);
    }

    public static Date formatZonedDate(String date) throws ParseException {
        if (TextUtil.isBlank((String)date)) {
            return null;
        }
        SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        DF.setTimeZone(TimeZone.getTimeZone("Europe/Moscow"));
        return DF.parse(date);
    }

    public static DictionaryReference<PassengerType> convertPassengerTypeFromGds(String gdsValue) {
        PassengerTypeValue type = (PassengerTypeValue)CollectionUtil.getKeyByValue(passengerTypeMap, (Object)gdsValue);
        return type != null ? ((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)type)).toReference() : DictHelper.getAdultPassengerType();
    }

    public static Date addTimeToDate(Date date, String time) throws Exception {
        if (date == null) {
            return null;
        }
        if (TextUtil.isBlank((String)time)) {
            return date;
        }
        String strDate = IMHelper.formatDateDay(date);
        strDate = strDate.replaceAll("00:00.*", time);
        return IMHelper.formatDate(strDate);
    }

    public static int calculateIncludedSeats(String rules) {
        switch (rules) {
            case "TwoPlacesAtOnce": 
            case "TwoPlacesAtOnceWithAdditionalChild": {
                return 2;
            }
            case "FourPlacesAtOnce": 
            case "KupekTariff": {
                return 4;
            }
        }
        return 1;
    }

    public static int calcAddSeats(List<RzdTraveller> rzdTravellers, PlacingRequirements placing) {
        int travellersSeatsCount = RailwayHelper.calcTravellersSeatsCount(rzdTravellers);
        int seatsAmount = MiscUtil.guarded((Integer)placing.getSeatsAmount());
        int addSeats = seatsAmount - travellersSeatsCount;
        if (addSeats < 0 || rzdTravellers.size() == 1 && rzdTravellers.get(0).getTariff().equals((Object)RzdTariff.SINGLE)) {
            addSeats = 0;
        }
        return addSeats;
    }

    public static RzdPriceValues buildPriceValues(Carriage car) {
        BigDecimal serviceCost = car.getServiceCost();
        BigDecimal minTariff = MiscUtil.guarded((BigDecimal)car.getMinPrice());
        BigDecimal maxTariff = MiscUtil.guarded((BigDecimal)car.getMaxPrice());
        if (BigDecimal.ZERO.compareTo(maxTariff) == 0) {
            maxTariff = minTariff;
        }
        return IMHelper.createPriceValues(minTariff, maxTariff, serviceCost);
    }

    private static RzdPriceValues createPriceValues(BigDecimal minTariff, BigDecimal maxTariff, BigDecimal serviceCost) {
        RzdPriceValues pv = new RzdPriceValues();
        pv.setOriginal(maxTariff);
        pv.setOriginalMin(minTariff);
        pv.setServiceCost(serviceCost);
        return pv;
    }

    public static String getOrderId(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.DEFAULT);
    }

    public static String getOrderItemId(RailwayProduct railwayProduct) {
        return IMHelper.getOrderItemId(railwayProduct, false);
    }

    public static String getOrderItemId(RailwayProduct railwayProduct, boolean withRefundTransId) {
        if (withRefundTransId && railwayProduct.getStatus() == ProductStatus.REFUND) {
            return railwayProduct.getRefundTransId();
        }
        return railwayProduct.getImData().getOrderItemId();
    }

    public static String buildMealGdsId(String mealTime, String mealOptionCode) {
        return Stream.of(mealTime, mealOptionCode).collect(Collectors.joining(MEAL_GDS_ID_SEPARATOR));
    }

    public static String getMealTime(String mealAncillaryFeeGdsId) {
        return mealAncillaryFeeGdsId.split(MEAL_GDS_ID_SEPARATOR)[0];
    }

    public static String getMealOptionCode(String mealAncillaryFeeGdsId) {
        return mealAncillaryFeeGdsId.split(MEAL_GDS_ID_SEPARATOR)[1];
    }

    public static void fillRefundBlankPriceVatInfo(RefundTransactionInfo.BlankPrice bp, VatRateValuesProvider vatRateValuesProvider) {
        if (vatRateValuesProvider == null || CollectionUtil.isEmpty(vatRateValuesProvider.getVatRateValues())) {
            return;
        }
        List<VatRateValue> vatRateValues = vatRateValuesProvider.getVatRateValues();
        VatRateValue vat = vatRateValues.get(0);
        bp.setTariffVat(vat.getValue());
        if (vat.getRate() != null) {
            bp.setTariffVatRate(vat.getRate().doubleValue());
        }
        if (vatRateValues.size() > 1) {
            vat = vatRateValues.get(1);
            bp.setServiceVat(vat.getValue());
            if (vat.getRate() != null) {
                bp.setServiceVatRate(vat.getRate().doubleValue());
            }
        }
        if (vatRateValues.size() > 3) {
            vat = vatRateValues.get(3);
            bp.setPenaltyVat(vat.getValue());
            if (vat.getRate() != null) {
                bp.setPenaltyVatRate(vat.getRate().doubleValue());
            }
        }
    }

    public static void fillServiceReturnRequest(ServiceReturnRequest req, Reservation reservation, String orderItemId, String blankId) {
        req.setOrderItemId(orderItemId);
        req.setCheckDocumentNumber(IMHelper.getDocNumber(reservation));
        if (!TextUtil.isBlank((String)blankId)) {
            req.setOrderItemBlankIds(Collections.singletonList(blankId));
        }
    }

    private static String getDocNumber(Reservation reservation) {
        Traveller tr = RzdCommonHelper.getFirstAdultTraveller((Reservation)reservation);
        return tr == null ? null : tr.getPassport().getNumber();
    }

    public static String getPaymentForm(PaymentType paymentType) {
        if (null == paymentType) {
            return null;
        }
        if (paymentType == PaymentType.CASH) {
            return CASH;
        }
        if (paymentType == PaymentType.INVOICE || BookingConverterHelper.isCreditCardPaymentType(paymentType)) {
            return BANK_CARD;
        }
        if (paymentType.name().startsWith("YANDEX")) {
            return YANDEX_MONEY;
        }
        return null;
    }

    public static boolean isAvailable(BaseCarriage car) {
        return "Available".equalsIgnoreCase(car.getAvailabilityIndication());
    }

    public static MainServiceReference buildMainServiceReference(RailwayProduct product) {
        MainServiceReference serviceRef = new MainServiceReference();
        serviceRef.setOrderItemId(IMHelper.getOrderItemId(product));
        serviceRef.setOrderItemBlankId(product.getBlankId());
        return serviceRef;
    }

    public static void fillAvailableAncillaryFees(Set<RailwayMcoCategory> availableAncillaryFees, BaseCarriage carriage) {
        if (carriage.isAdditionalMealOptionPossible()) {
            availableAncillaryFees.add(RailwayMcoCategory.MEAL);
        }
        carriage.getAvailableBaggageTypes().stream().map(BaseCarriage.AvailableBaggageType::getType).map(IMHelper::convertMcoCategoryFromGds).filter(Objects::nonNull).forEach(availableAncillaryFees::add);
    }

    public static List<RailAncillaryFeeReservationParameters> filterBaggage(List<RailAncillaryFeeReservationParameters> list) {
        return list.stream().filter(afp -> RailwayHelper.BAGGAGE_MCO_CATEGORIES.contains(afp.getAncillaryFee().getMcoCategory())).collect(Collectors.toList());
    }

    public static BaggageRequest buildBaggageRequest(RailwayMcoCategory mcoCategory, RailAncillaryFeeBaggageParameters baggageParams) {
        switch (mcoCategory) {
            case HAND_BAGGAGE: {
                return IMHelper.buildExtraHandLuggageRequest((RailAncillaryFeeHandBaggageParameters)baggageParams);
            }
            case PET_BAGGAGE: {
                return IMHelper.buildAnimalTransportationRequest((RailAncillaryFeePetBaggageParameters)baggageParams);
            }
            case LUGGAGE_IN_RAILWAY_ROOM: {
                return IMHelper.buildLuggageInBaggageRoomRequest((RailAncillaryFeeLuggageInRailwayRoomParameters)baggageParams);
            }
        }
        throw Xeption.forDeveloper((String)"Unsupported mcoCategory {0}", (Object[])new Object[]{mcoCategory});
    }

    private static RailwayExtraHandLuggageRequest buildExtraHandLuggageRequest(RailAncillaryFeeHandBaggageParameters params) {
        RailwayExtraHandLuggageRequest result = new RailwayExtraHandLuggageRequest();
        result.setLuggageType(IMHelper.convertHandBaggageTypeToGds(params.getType()));
        result.setBaggageName(params.getDescription());
        return result;
    }

    private static RailwayAnimalTransportationRequest buildAnimalTransportationRequest(RailAncillaryFeePetBaggageParameters params) {
        RailwayAnimalTransportationRequest result = new RailwayAnimalTransportationRequest();
        result.setAnimalDescription(params.getDescription());
        return result;
    }

    private static RailwayLuggageInBaggageRoomRequest buildLuggageInBaggageRoomRequest(RailAncillaryFeeLuggageInRailwayRoomParameters params) {
        RailwayLuggageInBaggageRoomRequest result = new RailwayLuggageInBaggageRoomRequest();
        result.setBaggageName(params.getDescription());
        result.setBaggagePlaceQuantity(params.getPlaceQuantity());
        result.setBaggageRoomCarNumber(params.getCarNumber());
        result.setBaggageDeclaredValue(params.getDeclaredPrice());
        return result;
    }

    public static Set<RailwayMcoCategory> getRailwayMcoCategories(Collection<BaseProduct> products) {
        return products.stream().filter(RailwayMcoProduct.class::isInstance).map(RailwayMcoProduct.class::cast).map(RailwayMcoProduct::getMcoCategory).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Collection<String> composeRequestTypes(Set<RailwayMcoCategory> mcoCategories) {
        ArrayList<String> result = new ArrayList<String>();
        if (mcoCategories.contains(RailwayMcoCategory.MEAL)) {
            result.add("meal");
        }
        if (CollectionUtil.containAtLeastOneCommonElement(mcoCategories, RailwayHelper.BAGGAGE_MCO_CATEGORIES)) {
            result.add("baggage");
        }
        return result;
    }

    static {
        genderMap.put(Gender.FEMALE, "Female");
        genderMap.put(Gender.MALE, "Male");
        genderMap.put(null, "NoValue");
        passportTypeMap.put(PassportType.INTERNAL, "RussianPassport");
        passportTypeMap.put(PassportType.BIRTHDAY_NOTIFICATION, "BirthCertificate");
        passportTypeMap.put(PassportType.PASSPORT, "ForeignPassport");
        passportTypeMap.put(PassportType.FOREIGN, "RussianForeignPassport");
        passportTypeMap.put(PassportType.SEAMANSID, "SailorPassport");
        passportTypeMap.put(PassportType.MILITARYID, "MilitaryCard");
        passportTypeMap.put(PassportType.MILITARYCERTIFICATE, "MilitaryOfficerCard");
        passportTypeMap.put(PassportType.IDENTITYCARD, "StatelessPersonIdentityCard");
        passportTypeMap.put(PassportType.BACKTOUSSRCERTIFICATE, "ReturnToCisCertificate");
        passportTypeMap.put(PassportType.DIPLOMATIC, "DiplomaticPassport");
        passportTypeMap.put(PassportType.SERVICE_PASSPORT, "ServicePassport");
        passportTypeMap.put(PassportType.PERMANENTRESIDENTCARD, "ResidencePermit");
        passportTypeMap.put(PassportType.INTERIMCERTIFICATE, "RussianTemporaryIdentityCard");
        kupeIndicationMap.put(KupeIndication.ANY, "NoValue");
        kupeIndicationMap.put(KupeIndication.ONE_KUPE, "InOneCabin");
        kupeIndicationMap.put(KupeIndication.ANY_KUPE, "NoSidePlaces");
        kupeIndicationMap.put(KupeIndication.ONE_SECTION, "InOneCompartment");
        compartmentTypeMap.put(CompartmentType.MEN, "Male");
        compartmentTypeMap.put(CompartmentType.WOMEN, "Female");
        compartmentTypeMap.put(CompartmentType.COMMON, "Mixed");
        rzdStatusMap.put("ElectronicRegistrationAbsent", RzdStatus.NO_ER);
        rzdStatusMap.put("ElectronicRegistrationPresent", RzdStatus.WITH_ER);
        rzdStatusMap.put("NotConfirmed", RzdStatus.NOT_CONFIRMED);
        rzdStatusMap.put("Voided", RzdStatus.CANCEL);
        rzdStatusMap.put("Returned", RzdStatus.REFUND);
        rzdStatusMap.put("PlacesReturned", RzdStatus.PLACES_REFUND);
        rzdStatusMap.put("VoucherIssued", RzdStatus.PRINT);
        rzdStatusMap.put("TripWasInterrupted", RzdStatus.INTERRUPTED_TRIP);
        rzdStatusMap.put("TripWasInterruptedAndResumedAfter", RzdStatus.INTERRUPTED_AND_RESUMED_TRIP);
        rzdStatusMap.put("", RzdStatus.ER_ERROR);
        rzdStatusMap.put(null, RzdStatus.ER_ERROR);
        carriageTypeMap.put(CarriageType.O, "Shared");
        carriageTypeMap.put(CarriageType.S, "Sedentary");
        carriageTypeMap.put(CarriageType.P, "ReservedSeat");
        carriageTypeMap.put(CarriageType.K, "Compartment");
        carriageTypeMap.put(CarriageType.M, "Soft");
        carriageTypeMap.put(CarriageType.L, "Luxury");
        tariffsMap.put(RzdTariff.SCHOOL, "Pupil");
        tariffsMap.put(RzdTariff.FULL, "Full");
        tariffsMap.put(RzdTariff.KUPEK, "Kupek");
        tariffsMap.put(RzdTariff.SINGLE, "Single");
        passengerTypeMap.put(PassengerTypeValue.ADULT, "Adult");
        passengerTypeMap.put(PassengerTypeValue.CHILD, "Child");
        passengerTypeMap.put(PassengerTypeValue.INFANT, "BabyWithoutPlace");
        carPlaceTypeMap.put("NoValue", CarPlaceType.NO_VALUE);
        carPlaceTypeMap.put("SeparateCompartment", CarPlaceType.SEPARATE_COMPARTMENT);
        carPlaceTypeMap.put("SideLowerNearRestroom", CarPlaceType.SIDE_LOWER_NEAR_RESTROOM);
        carPlaceTypeMap.put("SideUpperNearRestroom", CarPlaceType.SIDE_UPPER_NEAR_RESTROOM);
        carPlaceTypeMap.put("ThirdShelf", CarPlaceType.THIRD_SHELF);
        carPlaceTypeMap.put("Foldable", CarPlaceType.FOLDABLE);
        carPlaceTypeMap.put("Upper", CarPlaceType.UPPER);
        carPlaceTypeMap.put("Lower", CarPlaceType.LOWER);
        carPlaceTypeMap.put("Usual", CarPlaceType.USUAL);
        carPlaceTypeMap.put("LastKupeLower", CarPlaceType.LAST_KUPE_LOWER);
        carPlaceTypeMap.put("LastKupeUpper", CarPlaceType.LAST_KUPE_UPPER);
        carPlaceTypeMap.put("Middle", CarPlaceType.MIDDLE);
        carPlaceTypeMap.put("WithBicycle", CarPlaceType.WITH_BICYCLE);
        carPlaceTypeMap.put("SideLower", CarPlaceType.SIDE_LOWER);
        carPlaceTypeMap.put("SideUpper", CarPlaceType.SIDE_UPPER);
        carPlaceTypeMap.put("NearPlayground", CarPlaceType.NEAR_PLAYGROUND);
        carPlaceTypeMap.put("NearTablePlayground", CarPlaceType.NEAR_TABLE_PLAYGROUND);
        carPlaceTypeMap.put("NearTable", CarPlaceType.NEAR_TABLE);
        carPlaceTypeMap.put("WithPets", CarPlaceType.WITH_PETS);
        carPlaceTypeMap.put("MotherAndBaby", CarPlaceType.MOTHER_AND_BABY);
        carPlaceTypeMap.put("WithChild", CarPlaceType.WITH_CHILD);
        carPlaceTypeMap.put("NearPassengersWithPets", CarPlaceType.NEAR_PASSENGERS_WITH_PETS);
        carPlaceTypeMap.put("Invalids", CarPlaceType.INVALIDS);
        carPlaceTypeMap.put("InvalidsLower", CarPlaceType.INVALIDS_LOWER);
        carPlaceTypeMap.put("InvalidsUpper", CarPlaceType.INVALIDS_UPPER);
        carPlaceTypeMap.put("Negotiations", CarPlaceType.NEGOTIATIONS);
        carPlaceTypeMap.put("NearTableForward", CarPlaceType.NEAR_TABLE_FORWARD);
        carPlaceTypeMap.put("NearTableBackward", CarPlaceType.NEAR_TABLE_BACKWARD);
        carPlaceTypeMap.put("NoTableForward", CarPlaceType.NO_TABLE_FORWARD);
        carPlaceTypeMap.put("NoTableBackward", CarPlaceType.NO_TABLE_BACKWARD);
        carPlaceTypeMap.put("NoWindowForward", CarPlaceType.NO_WINDOW_FORWARD);
        carPlaceTypeMap.put("NoWindowBackward", CarPlaceType.NO_WINDOW_BACKWARD);
        carPlaceTypeMap.put("SingleForward", CarPlaceType.SINGLE_FORWARD);
        carPlaceTypeMap.put("NearRestroom", CarPlaceType.NEAR_RESTROOM);
        carPlaceTypeMap.put("FoldableNearRestroom", CarPlaceType.FOLDABLE_NEAR_RESTROOM);
        carPlaceTypeMap.put("NearRestroomAndBackward", CarPlaceType.NEAR_RESTROOM_AND_BACKWARD);
        carPlaceTypeMap.put("NearRestroomAndForward", CarPlaceType.NEAR_RESTROOM_AND_FORWARD);
        carPlaceTypeMap.put("NoTableAndNoWindow", CarPlaceType.NO_TABLE_AND_NO_WINDOW);
        carPlaceTypeMap.put("Side", CarPlaceType.SIDE);
        carPlaceTypeMap.put("WithoutPlace", CarPlaceType.WITHOUT_PLACE);
        carPlaceTypeMap.put("WithHigherLevelOfNoise", CarPlaceType.WITH_HIGHER_LEVEL_OF_NOISE);
        carPlaceTypeMap.put("FoldableOrWithHigherLevelOfNoise", CarPlaceType.FOLDABLE_OR_WITH_HIGHER_LEVEL_OF_NOISE);
        carPlaceTypeMap.put("SideLowerWithHigherLevelOfNoise", CarPlaceType.SIDE_LOWER_WITH_HIGHER_LEVEL_OF_NOISE);
        carPlaceTypeMap.put("SideUpperWithHigherLevelOfNoise", CarPlaceType.SIDE_UPPER_WITH_HIGHER_LEVEL_OF_NOISE);
        carPlaceTypeMap.put("AisleSeat", CarPlaceType.AISLE_SEAT);
        carPlaceTypeMap.put("AisleSeatWithHigherLevelOfNoise", CarPlaceType.AISLE_SEAT_WITH_HIGHER_LEVEL_OF_NOISE);
        carPlaceTypeMap.put("UpperInTwoPlaceCompartment", CarPlaceType.UPPER_IN_TWO_PLACE_COMPARTMENT);
        carPlaceTypeMap.put("LowerInTwoPlaceCompartment", CarPlaceType.LOWER_IN_TWO_PLACE_COMPARTMENT);
        carPlaceTypeMap.put("LastCompartmentLowerWithHigherLevelOfNoise", CarPlaceType.LAST_COMPARTMENT_LOWER_WITH_HIGHER_LEVEL_OF_NOISE);
        carPlaceTypeMap.put("LastCompartmentUpperWithHigherLevelOfNoise", CarPlaceType.LAST_COMPARTMENT_UPPER_WITH_HIGHER_LEVEL_OF_NOISE);
        carPlaceTypeMap.put("WithWindow", CarPlaceType.WITH_WINDOW);
        carPlaceTypeMap.put("WithWindowOpposite", CarPlaceType.WITH_WINDOW_OPPOSITE);
        carPlaceTypeMap.put("NoWindow", CarPlaceType.NO_WINDOW);
        carPlaceTypeMap.put("UpperWithChild", CarPlaceType.UPPER_WITH_CHILD);
        carPlaceTypeMap.put("UsualNoTable", CarPlaceType.USUAL_NO_TABLE);
        carPlaceTypeMap.put("Opposite", CarPlaceType.OPPOSITE);
        carPlaceTypeMap.put("LowerWithChild", CarPlaceType.LOWER_WITH_CHILD);
        carPlaceTypeMap.put("OppositeBackward", CarPlaceType.OPPOSITE_BACKWARD);
        carPlaceTypeMap.put("OppositeForward", CarPlaceType.OPPOSITE_FORWARD);
        carPlaceTypeMap.put("LastCompartmentLower", CarPlaceType.LAST_COMPARTMENT_LOWER);
        carPlaceTypeMap.put("LastCompartmentUpper", CarPlaceType.LAST_COMPARTMENT_UPPER);
        carPlaceTypeMap.put("NoTableWithWindowBackward", CarPlaceType.NO_TABLE_WITH_WINDOW_BACKWARD);
        carPlaceTypeMap.put("WithWindowOppositeForward", CarPlaceType.WITH_WINDOW_OPPOSITE_FORWARD);
        carPlaceTypeMap.put("WithWindowOppositeBackward", CarPlaceType.WITH_WINDOW_OPPOSITE_BACKWARD);
        carPlaceTypeMap.put("NoTableWithWindowForward", CarPlaceType.NO_TABLE_WITH_WINDOW_FORWARD);
        mcoCategoriesMap = new HashMap<String, RailwayMcoCategory>();
        mcoCategoriesMap.put("HandLuggage", RailwayMcoCategory.HAND_BAGGAGE);
        mcoCategoriesMap.put("PetTransportation", RailwayMcoCategory.PET_BAGGAGE);
        mcoCategoriesMap.put("LuggageInBaggageRoom", RailwayMcoCategory.LUGGAGE_IN_RAILWAY_ROOM);
        mcoCategoriesMap.put("OversizedLuggage", RailwayMcoCategory.OVERSIZED_BAGGAGE);
        mcoCategoriesMap.put("CarTransportation", RailwayMcoCategory.CAR_BAGGAGE);
        mcoCategoriesByTypeMap = new HashMap<String, RailwayMcoCategory>();
        mcoCategoriesByTypeMap.put("ExtraHandLuggage", RailwayMcoCategory.HAND_BAGGAGE);
        mcoCategoriesByTypeMap.put("AnimalTransportation", RailwayMcoCategory.PET_BAGGAGE);
        mcoCategoriesByTypeMap.put("LuggageInBaggageRoomOfPassengerCar", RailwayMcoCategory.LUGGAGE_IN_RAILWAY_ROOM);
        mcoCategoriesByTypeMap.put("OversizedLuggageWithSpecialCondition", RailwayMcoCategory.OVERSIZED_BAGGAGE);
        mcoCategoriesByTypeMap.put("CarTransportation", RailwayMcoCategory.CAR_BAGGAGE);
        bonusCardTypesMap = new HashMap<String, RzdBonusCardType>();
        bonusCardTypesMap.put("RzhdBonus", RzdBonusCardType.RZHD_BONUS);
        bonusCardTypesMap.put("UniversalRzhdCard", RzdBonusCardType.UNIVERSAL_RZHD_CARD);
        bonusCardTypesMap.put("BusinessTravel", RzdBonusCardType.BUSINESS_TRAVEL);
        handBaggageTypesMap = new HashMap<HandBaggageType, String>();
        handBaggageTypesMap.put(HandBaggageType.ELECTRONIC_EQUIPMENT, "ElectronicEquipment");
        handBaggageTypesMap.put(HandBaggageType.HOUSEHOLD_EQUIPMENT, "HouseholdEquipment");
        handBaggageTypesMap.put(HandBaggageType.AUDIO_VIDEO_EQUIPMENT, "AudioVisualEquipment");
    }
}

