/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.checkReservation;

import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.checkReservation.IMCheckReservationItem;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Blank;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMGetOrderInfoResp;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RefundTransactionInfo;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RzdReturnStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class IMReservationCheckRefundParamsBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IMCheckReservationItem checkItem = (IMCheckReservationItem)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_CHECK_RESERVATION_ITEM);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRANS_INFO_LIST, this.buildRefundReservationParams(checkItem));
    }

    private List<RefundTransactionInfo> buildRefundReservationParams(IMCheckReservationItem checkItem) throws Exception {
        ArrayList<RefundTransactionInfo> result = new ArrayList<RefundTransactionInfo>();
        for (IMGetOrderInfoResp.OrderItem refundItem : checkItem.getRefundItems()) {
            RefundTransactionInfo refTransInfo = new RefundTransactionInfo();
            refTransInfo.setRefundTransId(refundItem.getOrderItemId());
            refTransInfo.setExternalRufund(refundItem.isExternallyLoaded());
            refTransInfo.setStatus(RzdReturnStatus.SUCCESS);
            refTransInfo.setRefundDate(IMHelper.formatZonedDate(refundItem.getConfirmDateTime()));
            for (Blank blank : refundItem.getBlanks()) {
                RefundTransactionInfo.BlankPrice bp = new RefundTransactionInfo.BlankPrice();
                bp.setBlankId(blank.getPreviousBlankId());
                bp.setRefundBlankId(blank.getBlankId());
                bp.setPrice(blank.getAmount());
                IMHelper.fillRefundBlankPriceVatInfo(bp, blank);
                refTransInfo.getBlankPrices().add(bp);
            }
            result.add(refTransInfo);
        }
        return result;
    }
}

