/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.checkReservation;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.ticketReservation.RzdReservationTicketingParamsProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.checkReservation.IMCheckReservationItem;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMGetOrderInfoResp;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.BlankTicketNumberProvider;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;

public class IMReservationCheckTicketParamsBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IMCheckReservationItem checkItem = (IMCheckReservationItem)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_CHECK_RESERVATION_ITEM);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKET_RESERVATION_PARAMETERS, (Object)this.buildCreateReservationParams(checkItem.getOrderItem()));
    }

    private RzdReservationTicketingParamsProvider buildCreateReservationParams(final IMGetOrderInfoResp.OrderItem orderItem) throws Exception {
        String eRegExpireDateStr = orderItem.getERegExpireDatetime();
        final Date eRegExpireDate = TextUtil.isBlank((String)eRegExpireDateStr) ? null : IMHelper.formatZonedDate(eRegExpireDateStr);
        return new RzdReservationTicketingParamsProvider(){

            @Override
            public String getOrderNumber() {
                return orderItem.getOrderId();
            }

            @Override
            public List<? extends BlankTicketNumberProvider> getTicketNumbers() {
                return orderItem.getBlanks();
            }

            @Override
            public EntityReference<Person> getAgent() {
                return null;
            }

            @Override
            public Date getRefundExpireDate() {
                return eRegExpireDate;
            }

            @Override
            public Date getERegChangeExpireDate() {
                return eRegExpireDate;
            }
        };
    }
}

