/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.checkReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.checkReservation.IMCheckReservationItem;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Blank;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMGetOrderInfoResp;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;
import java.util.stream.Stream;

public class IMReservationStatusProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        IMCheckReservationItem checkItem = (IMCheckReservationItem)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_CHECK_RESERVATION_ITEM);
        Map oldStatuses = (Map)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_RESERVATION_OLD_STATUSES);
        if (this.isInProcess(checkItem)) {
            reservation.setStatus((ReservationStatus)oldStatuses.get(reservation));
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0421\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u043a\u0430\u0437\u0430: \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} ({1}) \u0432 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), checkItem.getOrderItem().getOrderItemId()}));
            return null;
        }
        ProductStatus status = this.calcStatus(checkItem);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT_STATUS, (Object)status);
        if (status == null) {
            reservation.setStatus(ReservationStatus.ERROR);
            return null;
        }
        return status.name();
    }

    private ProductStatus calcStatus(IMCheckReservationItem checkItem) {
        IMGetOrderInfoResp.OrderItem orderItem = checkItem.getOrderItem();
        if (orderItem.getOperationStatus() == null) {
            return null;
        }
        if (this.isBookingRzhdStatuses(orderItem)) {
            return ProductStatus.BOOKING;
        }
        switch (orderItem.getOperationStatus()) {
            case "Error": {
                return ProductStatus.VOID_BOOKING;
            }
            case "Succeeded": {
                return this.existsRefund(orderItem) ? ProductStatus.REFUND : ProductStatus.SELL;
            }
        }
        return null;
    }

    private boolean isBookingRzhdStatuses(IMGetOrderInfoResp.OrderItem orderItem) {
        for (Blank bi : orderItem.getBlanks()) {
            RzdStatus rzdStatus = IMHelper.convertStatusFromGds(bi.getStatus());
            if (rzdStatus == RzdStatus.NOT_CONFIRMED) continue;
            return false;
        }
        return true;
    }

    private boolean isInProcess(IMCheckReservationItem checkItem) {
        return Stream.concat(Stream.of(checkItem.getOrderItem()), checkItem.getRefundItems().stream()).anyMatch(item -> "InProcess".equals(item.getOperationStatus()) || item.getBlanks().stream().anyMatch(blank -> "ToCancel".equals(blank.getPendingElectronicRegistration())));
    }

    private boolean existsRefund(IMGetOrderInfoResp.OrderItem orderItem) {
        for (Blank bi : orderItem.getBlanks()) {
            RzdStatus rzdStatus = IMHelper.convertStatusFromGds(bi.getStatus());
            if (rzdStatus != RzdStatus.REFUND) continue;
            return true;
        }
        return false;
    }
}

