/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.PlacingRequirements;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.AgeRestrictionCalculator;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBonusCardType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMUrlSuffix;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Passenger;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.RailwayCard;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.request.IMReservationCreateReq;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class IMBuyTicketRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        RzdReservationCreationParameters params = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Customer customer = (Customer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        PaymentType payment = (PaymentType)ctx.getObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        ctx.putObject((Enum)IBusIMContextKeys.IM_REQUEST_PARAMETERS, (Object)new IMRequestParameters(IMUrlSuffix.ReservationCreate, this.buildRequestData(params, customer, travellers, payment)));
    }

    private IMReservationCreateReq buildRequestData(RzdReservationCreationParameters params, Customer customer, List<Traveller> travellers, PaymentType paymentType) {
        IMReservationCreateReq request = new IMReservationCreateReq();
        request.getContactEmails().addAll(customer.getCommunications().stream().filter(c -> c.getType() == CommunicationType.EMAIL).map(Communication::getSense).collect(Collectors.toList()));
        customer.getCommunications().stream().filter(c -> c.getType() == CommunicationType.MOBILE).findFirst().ifPresent(c -> request.setContactPhone(CommonHelper.buildPhoneNumber(c)));
        boolean isOnePassenger = this.isOnePassenger(travellers);
        boolean isFullCompartmentCase = this.isFullCompartmentCase(params, isOnePassenger);
        List<Traveller> requestTravellers = isFullCompartmentCase ? this.getUniqueTravellers(travellers) : travellers;
        this.buildReservationItem(1, request, params.getSegment(), requestTravellers, params.getRzdTravellers(), paymentType);
        if (params.getSegmentBack() != null) {
            this.buildReservationItem(2, request, params.getSegmentBack(), requestTravellers, params.getRzdTravellers(), paymentType);
        }
        return request;
    }

    private void buildReservationItem(Integer index, IMReservationCreateReq request, RzdBookingSegmentParams segment, List<Traveller> requestTravellers, List<RzdTraveller> rzdTravellers, PaymentType paymentType) {
        IMReservationCreateReq.ReservationItems reservationItem = new IMReservationCreateReq.ReservationItems();
        reservationItem.setIndex(index);
        reservationItem.setPaymentForm(IMHelper.getPaymentForm(paymentType));
        request.getReservationItems().add(reservationItem);
        this.addSegment(reservationItem, segment, rzdTravellers);
        this.addCustomers(request.getCustomers(), reservationItem, rzdTravellers, segment, requestTravellers);
    }

    private boolean isOnePassenger(List<Traveller> travellers) {
        Passport passport = null;
        for (Traveller traveller : travellers) {
            if (passport == null) {
                passport = traveller.getPassport();
                continue;
            }
            if (RzdCommonHelper.isSamePassports((Passport)passport, (Passport)traveller.getPassport(), (boolean)true)) continue;
            return false;
        }
        return true;
    }

    private boolean isFullCompartmentCase(RzdReservationCreationParameters params, boolean isOnePassenger) {
        Integer segmentFullCompartmentValue = this.getIsFullCompartmentValue(params.getSegment(), isOnePassenger);
        if (params.getSegmentBack() == null) {
            return segmentFullCompartmentValue != null;
        }
        Integer segmentBackFullCompartmentValue = this.getIsFullCompartmentValue(params.getSegmentBack(), isOnePassenger);
        return segmentFullCompartmentValue != null && segmentBackFullCompartmentValue != null;
    }

    private List<Traveller> getUniqueTravellers(List<Traveller> travellers) {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        for (Traveller traveller : travellers) {
            if (RzdHelper.findTravellerByPassport(traveller.getPassport(), result) != null) continue;
            result.add(traveller);
        }
        return result;
    }

    private void addSegment(IMReservationCreateReq.ReservationItems reservationItem, RzdBookingSegmentParams params, List<RzdTraveller> rzdTravellers) {
        PlacingRequirements plReq;
        boolean remoteCheckIn = params.getRzdCar().isERegEnabled();
        reservationItem.setOriginCode(params.getTrain().getPassengerFrom().getCode());
        reservationItem.setDestinationCode(params.getTrain().getPassengerTo().getCode());
        reservationItem.setDepartureDate(IMHelper.formatDate(params.getTrain().getDepartureDatetime()));
        reservationItem.setTrainNumber(params.getRzdPrice().getTrainNumber());
        reservationItem.setCarNumber(params.getRzdCar().getNumber());
        reservationItem.setProvider(params.getTrain().getTrainProvider());
        if (params.getRzdPrice().getCategory() != null) {
            reservationItem.setCarType(IMHelper.convertCarriageTypeToGds(params.getRzdPrice().getCategory()));
        }
        if (params.getRzdPrice().getServiceClass() != null) {
            reservationItem.setServiceClass(RzdServiceConverter.getServiceClassName((ServiceClass)params.getRzdPrice().getServiceClass()));
        }
        if (!TextUtil.isBlank((String)params.getRzdPrice().getInternationalServiceClass())) {
            reservationItem.setInternationalServiceClass(params.getRzdPrice().getInternationalServiceClass());
        }
        if ((plReq = params.getPlacing()) != null) {
            reservationItem.setCabinGenderKind(IMHelper.convertCompartmentTypeToGds(params.getPlacing().getGender()));
            if (plReq.getSeatRangeFirst() != null && plReq.getSeatRangeLast() != null) {
                IMReservationCreateReq.ReservationItems.PlaceRange range = new IMReservationCreateReq.ReservationItems.PlaceRange();
                range.setFrom(plReq.getSeatRangeFirst());
                range.setTo(plReq.getSeatRangeLast());
                reservationItem.setPlaceRange(range);
            }
            reservationItem.setLowerPlaceQuantity(plReq.getLowerSeatsCount());
            reservationItem.setUpperPlaceQuantity(plReq.getUpperSeatsCount());
            reservationItem.setCabinPlaceDemands(IMHelper.convertKupeIndicationToGds(plReq.getKupeIndication()));
            if (plReq.getWithBedding() != null) {
                reservationItem.setBedding(String.valueOf(plReq.getWithBedding()));
            }
        }
        reservationItem.hasEReg(remoteCheckIn);
        boolean isSuburbanTrain = RzdCommonHelper.isSuburbanTrain((String)params.getTrain().getDisplayNumber());
        if (!isSuburbanTrain) {
            reservationItem.setAdditionalPlaceRequirements(RailwayHelper.calcPlaceDemands(params));
            reservationItem.isAdditionalTariffForChild(this.isAdditionalTariffForChildAvailable(params.getRzdPrice(), rzdTravellers));
        }
    }

    private boolean isAdditionalTariffForChildAvailable(RzdPrice price, List<RzdTraveller> rzdTravellers) {
        boolean hasInfant = rzdTravellers.stream().anyMatch(tr -> DictHelper.isInfantPassengerTypeCategory((DictionaryReference)tr.getPassengerType()));
        boolean hasChild = rzdTravellers.stream().anyMatch(tr -> DictHelper.isChildPassengerTypeCategory((DictionaryReference)tr.getPassengerType()));
        String passengerSpecifyingRule = price.getPassengerSpecifyingRule();
        if ("TwoPlacesAtOnceWithAdditionalChild".equals(passengerSpecifyingRule) && !hasChild && hasInfant) {
            return true;
        }
        return passengerSpecifyingRule.equals("GiveAdditionalTariffForChildIfPossible");
    }

    private Integer getIsFullCompartmentValue(RzdBookingSegmentParams params, boolean isOnePassenger) {
        if (!params.getPlacing().isOneKupeAllSeats() || !isOnePassenger) {
            return null;
        }
        switch (params.getRzdPrice().getCategory()) {
            case K: {
                return 1;
            }
            case L: {
                return 2;
            }
        }
        return null;
    }

    private void addCustomers(List<com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Customer> customers, IMReservationCreateReq.ReservationItems reservationItem, List<RzdTraveller> rzdTravellers, RzdBookingSegmentParams params, List<Traveller> travellers) {
        boolean isSuburbanTrain = RzdCommonHelper.isSuburbanTrain((String)params.getTrain().getDisplayNumber());
        int addSeats = IMHelper.calcAddSeats(rzdTravellers, params.getPlacing());
        int customerCounter = 1;
        for (RzdTraveller rzdTraveller : rzdTravellers) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)rzdTraveller.getTravellerUid());
            if (traveller == null) continue;
            boolean isAdult = DictHelper.isAdultPassengerTypeCategory((DictionaryReference)rzdTraveller.getPassengerType());
            int count = 1;
            if (isAdult) {
                count += addSeats;
                addSeats = 0;
            }
            for (int i = 0; i < count; ++i) {
                Passport passport = traveller.getPassport();
                DictionaryReference countryRef = (DictionaryReference)MiscUtil.guarded((Object)passport.getCitizenship(), (Object)passport.getOriginCountry());
                com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Customer customer = new com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Customer();
                customer.setDocumentType(IMHelper.convertPassportTypeToGds(passport.getType(), (DictionaryReference<Country>)countryRef));
                customer.setDocumentNumber(passport.getNumber());
                customer.setLastName(passport.getLastName());
                customer.setFirstName(RailwayHelper.getFullFirstName(passport));
                customer.setMiddleName(passport.getMiddleName());
                if (passport.getBirthday() != null) {
                    customer.setDateOfBirth(IMHelper.formatDateDay(passport.getBirthday()));
                } else {
                    customer.setDateOfBirth(RzdHelper.getEmptyValue());
                }
                Country country = (Country)DictionaryCache.get().resolveReference(countryRef);
                if (country != null) {
                    String countryCode = DictHelper.getCodeVariant((BaseDictionary)country, (CodeSystem)CodeSystem.ISO);
                    if (TextUtil.isBlank((String)countryCode)) {
                        throw Xeption.forAdmin((String)"\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0441\u0442\u0440\u0430\u043d \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043a\u043e\u0434 \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f ({0}).", (Object[])new Object[]{country.getCode()});
                    }
                    customer.setCitizenship(countryCode);
                } else {
                    customer.setCitizenship(RzdHelper.getEmptyValue());
                }
                customer.setSex(IMHelper.convertGenderToGds(passport.getGender()));
                customer.setBirthPlace(passport.getBirthPlace());
                Date expirationDate = passport.getExpired();
                if (expirationDate != null) {
                    customer.setDocumentValidTime(IMHelper.formatDateDay(passport.getExpired()));
                }
                Passenger passenger = new Passenger();
                int index = customerCounter++;
                customer.setIndex(index);
                passenger.setCustomerIndex(index);
                RzdTariff correctedTariff = AgeRestrictionCalculator.correctRzdTariff((RzdTariff)rzdTraveller.getTariff(), (RzdTrain)params.getTrain(), (RzdPrice)params.getRzdPrice());
                this.setPassengerCategory(passenger, correctedTariff, params.getRzdPrice(), passport.getBirthday());
                if (!isSuburbanTrain) {
                    RailwayCard gdsBonusCard;
                    if (isAdult) {
                        String type = IMHelper.convertRzdTariffToGdsTariffType(rzdTraveller.getTariff());
                        passenger.setAdditionalTarrifType(type);
                    }
                    if ((gdsBonusCard = this.buildBonusCard(traveller.getRailwayBonusCard())) != null) {
                        passenger.setBonusCards(Collections.singletonList(gdsBonusCard));
                    }
                }
                passenger.setNonRefundableTariff(params.getRzdCar().isHasNonRefundableTariff() && rzdTraveller.isNonRefundableTariff());
                this.setPassengerCommunication(passenger, traveller);
                if (!customers.contains(customer)) {
                    customers.add(customer);
                }
                reservationItem.getPassengers().add(passenger);
            }
        }
    }

    private void setPassengerCommunication(Passenger passenger, Traveller traveller) {
        String email = ProfileHelper.getCommunicationEmail((List)traveller.getCommunications());
        Communication phoneComm = ProfileHelper.getPhoneCommunication((List)traveller.getCommunications());
        String phone = phoneComm != null ? CommonHelper.buildPhoneNumber(phoneComm) : null;
        passenger.setContactEmailOrPhone(!TextUtil.isBlank((String)email) ? email : phone);
        passenger.setPhone(phone);
    }

    private RailwayCard buildBonusCard(RailwayBonusCard bonusCard) {
        if (bonusCard == null || TextUtil.isBlank((String)bonusCard.getNumber())) {
            return null;
        }
        RailwayCard result = new RailwayCard();
        result.setCardNumber(bonusCard.getNumber());
        RzdBonusCardType bonusCardType = RzdBonusCardType.valueOf((String)bonusCard.getRailwayCarrierCode());
        result.setCardType(IMHelper.convertBonusCardTypeToGds(bonusCardType));
        return result;
    }

    private void setPassengerCategory(Passenger passenger, RzdTariff tariff, RzdPrice rzdPrice, Date birthDay) {
        switch (tariff) {
            case BABY: 
            case INFANT_6: 
            case INFANT_4: {
                passenger.setCategory("BabyWithoutPlace");
                break;
            }
            case INFANT_10: {
                if (MiscUtil.isAfter(null, (Date)MiscUtil.addYearsToDate((Date)birthDay, (int)5), (Date)rzdPrice.getDepartureDatetime()) && RzdCommonHelper.isLuxWithExtraInfants((RzdPrice)rzdPrice)) {
                    passenger.setCategory("Child");
                    break;
                }
                passenger.setCategory("BabyWithoutPlace");
                break;
            }
            case CHILD: 
            case CHILD_12: 
            case CHILD_17: 
            case CHILD_7: {
                passenger.setCategory("Child");
                break;
            }
            default: {
                passenger.setCategory("Adult");
            }
        }
    }
}

