/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.createReservation;

import com.gridnine.xtrip.common.ibecorp.model.InMobGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.FreeMealInfo;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Blank;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Customer;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Passenger;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.VatRateValue;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMReservationCreateResp;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IMReservationBuilder {
    private final IMReservationCreateResp response;
    private final List<Traveller> travellers;
    private final RzdReservationCreationParameters params;
    private InMobGdsAccount gdsAccount;
    private RzdGdsParameters gdsParams = new RzdGdsParameters();
    private final List<Message> messages = new ArrayList<Message>();

    IMReservationBuilder(IMReservationCreateResp response, RzdReservationCreationParameters params, List<Traveller> travellers) {
        this.response = response;
        this.travellers = travellers;
        this.params = params;
    }

    public IMReservationBuilder setAccountCtr(InMobGdsAccount gdsAccount) {
        this.gdsAccount = gdsAccount;
        return this;
    }

    public IMReservationBuilder setGdsParams(RzdGdsParameters gdsParams) {
        this.gdsParams = gdsParams;
        return this;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Reservation build() throws Exception {
        Reservation reservation = new Reservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)this.gdsAccount.getGds(), (RecordLocatorType)RecordLocatorType.DEFAULT, (String)this.response.getOrderID());
        reservation.setResDate(new Date());
        reservation.setTimeLimit(IMHelper.formatZonedDate(this.response.getConfirmTill()));
        this.response.getReservationResults().sort(Comparator.comparing(IMReservationCreateResp.ReservationResults::getIndex));
        boolean isFirst = true;
        for (IMReservationCreateResp.ReservationResults gdsReservation : this.response.getReservationResults()) {
            ArrayList<Traveller> lostTravellers = new ArrayList<Traveller>(this.travellers);
            RzdBookingSegmentParams segmentParams = isFirst ? this.params.getSegment() : this.params.getSegmentBack();
            int addSeats = IMHelper.calcAddSeats(this.params.getRzdTravellers(), segmentParams.getPlacing());
            if (addSeats > 0) {
                Traveller firstAdult = this.params.getRzdTravellers().stream().filter(tr -> DictHelper.isAdultPassengerTypeCategory((DictionaryReference)tr.getPassengerType())).findFirst().map(rzdTr -> this.travellers.stream().filter(tr -> MiscUtil.equals((Object)rzdTr.getTravellerUid(), (Object)tr.getUid())).findFirst().orElse(null)).orElseThrow(() -> Xeption.forDeveloper((String)"no adult traveller", (Object[])new Object[0]));
                for (int i = 0; i < addSeats; ++i) {
                    lostTravellers.add((Traveller)XCloneHelper.clone((XCloneable)firstAdult, (boolean)false));
                }
            }
            for (Blank gdsBlank : gdsReservation.getBlanks()) {
                RailwayProduct product = this.createProduct(gdsReservation, gdsBlank, lostTravellers, segmentParams);
                BookingHelper.addProduct((Reservation)reservation, (BaseProduct)product);
            }
            if (!lostTravellers.isEmpty()) {
                throw Xeption.forDeveloper((String)"Lost travellers in reservationResult with orderItem {0}: {1}", (Object[])new Object[]{gdsReservation.getOrderItemId(), lostTravellers.stream().map(Traveller::getName).collect(Collectors.joining(", "))});
            }
            isFirst = false;
        }
        return reservation;
    }

    private RailwayProduct createProduct(IMReservationCreateResp.ReservationResults gdsReservation, Blank gdsBlank, List<Traveller> travellers, RzdBookingSegmentParams segmentParams) throws Exception {
        Map customerIdxToPassengerMap = gdsReservation.getPassengers().stream().filter(pas -> MiscUtil.equals((Object)pas.getBlankID(), (Object)gdsBlank.getBlankId())).collect(Collectors.toMap(Passenger::getCustomerReferenceIndex, Function.identity()));
        Collection passengers = customerIdxToPassengerMap.values();
        List<Customer> customers = this.response.getCustomers().stream().filter(customer -> customerIdxToPassengerMap.containsKey(customer.getIndex())).collect(Collectors.toList());
        List<Traveller> productTravellers = this.findTravellers(customers, travellers);
        List<VatRateValue> vatRateValues = gdsBlank.getVatRateValues();
        VatRateValue fareVatRateValue = vatRateValues.size() > 0 ? vatRateValues.get(0) : null;
        VatRateValue serviceVatRateValue = vatRateValues.size() > 1 ? vatRateValues.get(1) : null;
        BigDecimal priceOriginal = MiscUtil.guarded((BigDecimal)gdsBlank.getAmount());
        BigDecimal equivalentVat = MiscUtil.guarded((BigDecimal)this.getVat(fareVatRateValue));
        BigDecimal serviceVat = MiscUtil.guarded((BigDecimal)this.getVat(serviceVatRateValue));
        String gdsCurrency = this.gdsAccount.getCurrency() == null ? null : this.gdsAccount.getCurrency().getCode();
        CarriageType carriageType = IMHelper.convertCarriageTypeFromGds(gdsReservation.getCarriageType());
        RailwayProduct product = new RailwayProduct();
        product.setTicketType(TicketType.OWN);
        product.setEticket(true);
        product.setIssueDate(new Date());
        product.setStatus(ProductStatus.BOOKING);
        product.setGdsCurrency(gdsCurrency);
        product.setBlankId(gdsBlank.getBlankId());
        product.getImData().setOrderItemId(gdsReservation.getOrderItemId());
        product.getPassengers().addAll(productTravellers);
        for (Traveller traveller : productTravellers) {
            RzdTraveller rzdTraveller = RailwayHelper.getRzdTraveller(traveller.getUid(), this.params.getRzdTravellers());
            RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, (DictionaryReference)rzdTraveller.getPassengerType());
            if (product.getIbecorpTariff() != null) continue;
            product.setIbecorpTariff(rzdTraveller.getTariff());
        }
        product.setGdsCurrency(gdsCurrency);
        product.setEquivalentFare(priceOriginal);
        product.setTotalEquivalentFare(priceOriginal);
        RailwayHelper.updateProductVats(product, equivalentVat, this.getVatRate(fareVatRateValue), serviceVat, this.getVatRate(serviceVatRateValue), this.messages);
        product.setCarriageAtrs(gdsReservation.getCarDescription());
        if (carriageType == CarriageType.P) {
            product.setWithBedding(Boolean.valueOf(gdsBlank.isBeddingIncluded()));
        }
        product.setBlankType(RzdHelper.getBlankType("\u0420\u0416\u0414 \u042d\u0411"));
        product.setCarrier(this.getPrincipal(gdsReservation));
        product.setNonRefundableTariff(gdsBlank.isNonRefundableTariff());
        RzdTrain train = segmentParams.getTrain();
        RzdPrice rzdPrice = segmentParams.getRzdPrice();
        RzdCar rzdCar = segmentParams.getRzdCar();
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(1);
        segment.setDepartureStation(RzdHelper.getStationRefByCode(gdsReservation.getOriginCode()));
        segment.setArriveStation(RzdHelper.getStationRefByCode(gdsReservation.getDestinationCode()));
        segment.setDepartureDate(train.getDepartureDatetime());
        segment.setArriveDate((Date)MiscUtil.guarded((Object)rzdCar.getArrivalDatetime(), (Object)train.getArrivalDatetime()));
        segment.setLocalDepartureDate(train.getLocalDepartureDatetime());
        segment.setLocalArriveDate((Date)MiscUtil.guarded((Object)rzdCar.getLocalArrivalDatetime(), (Object)train.getLocalArrivalDatetime()));
        segment.setTrainArriveToStationDate(train.getArrivalDatetime());
        segment.setTrainArriveToStationLocalDate(train.getLocalArrivalDatetime());
        RzdHelper.writeFullTrainNumber(segment, gdsReservation.getTrainNumber());
        segment.setTrainNumberOriginal(gdsReservation.getBookingTrainNumber());
        segment.setCarriageNumber(gdsReservation.getCarNumber());
        passengers.stream().map(Passenger::getPlaces).map(RailwayHelper::parseSeatNumber).flatMap(Collection::stream).forEach(segment.getPlaces()::add);
        segment.setCarriageType(carriageType);
        segment.setCompartmentType(IMHelper.convertCompartmentTypeFromGds(gdsReservation.getCabinGenderType()));
        segment.setServiceClass(RzdServiceConverter.getServiceClassByName((String)gdsReservation.getServiceClass()));
        if (gdsBlank.getAdditionalPrice() != null) {
            BigDecimal segmentFare = gdsBlank.getAdditionalPrice();
            segment.setEquivalentFare(segmentFare);
            segment.setFare(MoneyHelper.buildMoney((BigDecimal)segmentFare, (String)gdsCurrency));
        }
        segment.setERegEnabled(rzdCar.isERegEnabled());
        segment.setHasEReg(rzdCar.isERegEnabled());
        segment.setCarrier(RzdHelper.getCarrier(gdsReservation.getCarrier(), gdsReservation.getCarrierTin(), this.getLogInfoAboutTrain(gdsReservation)));
        segment.setRoute(RzdHelper.getRoute(rzdPrice.getRoute(), this.getLogInfoAboutTrain(gdsReservation)));
        segment.setTimeInfo(gdsReservation.getTimeDescription());
        segment.setTrainCategory(gdsReservation.getTrainDescription());
        segment.setInternational(Boolean.valueOf(train.isInternational()));
        product.getSegments().add(segment);
        BigDecimal reservedSeatFare = MiscUtil.sub((BigDecimal)gdsBlank.getBaseFare(), (BigDecimal[])new BigDecimal[]{gdsBlank.getService()});
        ReservedSeat reservedSeat = new ReservedSeat();
        reservedSeat.setSegment(segment);
        reservedSeat.setFare(MoneyHelper.buildMoney((BigDecimal)reservedSeatFare, (String)gdsCurrency));
        reservedSeat.setEquivalentFare(reservedSeatFare);
        reservedSeat.setEquivalentVAT(equivalentVat);
        product.getReservedSeats().add(reservedSeat);
        product.getImData().setTrainProvider(train.getTrainProvider());
        product.getImData().setCarrierCode(gdsReservation.getCarrierCode());
        product.getImData().setCountryCode(gdsReservation.getCountryCode());
        product.getImData().setMealOptionPossible(gdsReservation.isMealOptionPossible());
        product.getImData().getAvailableAncillaryFees().addAll(rzdCar.getAvailableAncillaryFees());
        if (!TextUtil.isBlank((String)gdsReservation.getMealGroup())) {
            product.getImData().setMealGroup(gdsReservation.getMealGroup());
        }
        if (gdsReservation.isMealOptionPossible()) {
            FreeMealInfo mealInfo = new FreeMealInfo();
            mealInfo.setCode("\u0421");
            mealInfo.setName("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442");
            mealInfo.setDescription("\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0442");
            product.setMealInfo(mealInfo);
        }
        return product;
    }

    private List<Traveller> findTravellers(List<Customer> customers, List<Traveller> travellers) {
        ArrayList<Traveller> result = new ArrayList<Traveller>();
        for (Customer customer : customers) {
            Traveller traveller = travellers.stream().filter(tr -> this.isSameTraveller((Traveller)tr, customer)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find traveller {0}, {1}-{2}", (Object[])new Object[]{customer.getLastName(), customer.getDocumentType(), customer.getDocumentNumber()}));
            travellers.remove(traveller);
            result.add(traveller);
        }
        return result;
    }

    private boolean isSameTraveller(Traveller traveller, Customer customer) {
        Passport psp = traveller.getPassport();
        String gdsDocType = IMHelper.convertPassportTypeToGds(psp.getType(), (DictionaryReference<Country>)psp.getCitizenship());
        return MiscUtil.equals((Object)psp.getNumber(), (Object)customer.getDocumentNumber()) && MiscUtil.equals((Object)gdsDocType, (Object)customer.getDocumentType()) && MiscUtil.equals((Object)this.modifyNameForGds(psp.getLastName()), (Object)this.modifyNameForGds(customer.getLastName())) && MiscUtil.equals((Object)this.modifyNameForGds(RailwayHelper.getFullFirstName(psp)), (Object)this.modifyNameForGds(customer.getFirstName()));
    }

    private String modifyNameForGds(String name) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        return RzdHelper.modifyNameForGds(name).toUpperCase();
    }

    private BigDecimal getVat(VatRateValue vatRateValue) {
        return vatRateValue != null ? vatRateValue.getValue() : null;
    }

    private Double getVatRate(VatRateValue vatRateValue) {
        return vatRateValue != null && vatRateValue.getRate() != null ? Double.valueOf(vatRateValue.getRate().doubleValue()) : null;
    }

    private DictionaryReference<Principal> getPrincipal(IMReservationCreateResp.ReservationResults gdsReservation) {
        String carrierPhone;
        String carrierTin = gdsReservation.getCarrierTin();
        DictionaryReference<Principal> principalRef = RzdHelper.getPrincipal(carrierTin, carrierPhone = null);
        if (principalRef == null) {
            principalRef = RzdHelper.createPrincipal(carrierTin, gdsReservation.getCarrierAddition(), carrierPhone);
        }
        return principalRef;
    }

    private String getLogInfoAboutTrain(IMReservationCreateResp.ReservationResults gdsReservation) {
        return "record locator=" + this.response.getOrderID() + ", orderItemId=" + gdsReservation.getOrderItemId();
    }
}

