/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.expandReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandProductParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandReservationParameters;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMUrlSuffix;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.request.ImAdditionalBaggageBookReq;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Map;

public class ImAdditionalBaggageBookRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailExpandReservationParameters params = (RailExpandReservationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.EXPAND_RESERVATION_PARAMETERS);
        PaymentType paymentType = (PaymentType)ctx.getObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        HashMap<RailAncillaryFeeReservationParameters, Integer> afParamsWithIndex = new HashMap<RailAncillaryFeeReservationParameters, Integer>();
        ctx.putObject((Enum)IBusIMContextKeys.IM_REQUEST_PARAMETERS, (Object)new IMRequestParameters(IMUrlSuffix.AdditionalBaggageBook, this.buildRequest(reservation, params, paymentType, afParamsWithIndex)));
        ctx.putObject((Enum)IBusIMContextKeys.IM_ANCILLARY_FEE_PARAMS_WITH_INDEX_MAP, afParamsWithIndex);
    }

    private ImAdditionalBaggageBookReq buildRequest(Reservation reservation, RailExpandReservationParameters params, PaymentType paymentType, Map<RailAncillaryFeeReservationParameters, Integer> afParamsWithIndex) {
        ImAdditionalBaggageBookReq result = new ImAdditionalBaggageBookReq();
        for (RailExpandProductParameters productParams : params.getProductParams()) {
            RailwayProduct product = RzdCommonHelper.getProductByUid((Reservation)reservation, (String)productParams.getProductUid());
            if (product == null) {
                throw Xeption.forDeveloper((String)"can't find railway product with uid {0}", (Object[])new Object[]{productParams.getProductUid()});
            }
            IMHelper.filterBaggage(productParams.getAncillaryFees()).stream().map(afp -> this.buildItem(product, (RailAncillaryFeeReservationParameters)afp, paymentType, afParamsWithIndex, result.getItems().size() + 1)).forEach(result.getItems()::add);
        }
        return result;
    }

    private ImAdditionalBaggageBookReq.BaggageBookItem buildItem(RailwayProduct product, RailAncillaryFeeReservationParameters params, PaymentType paymentType, Map<RailAncillaryFeeReservationParameters, Integer> afParamsWithIndex, int index) {
        ImAdditionalBaggageBookReq.BaggageBookItem result = new ImAdditionalBaggageBookReq.BaggageBookItem();
        result.setMainServiceReference(IMHelper.buildMainServiceReference(product));
        result.setBaggageRequest(IMHelper.buildBaggageRequest(params.getAncillaryFee().getMcoCategory(), params.getBaggageParameters()));
        result.setIndex(index);
        result.setPaymentForm(IMHelper.getPaymentForm(paymentType));
        afParamsWithIndex.put(params, index);
        return result;
    }
}

