/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.expandReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandProductParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.ImAdditionalBaggageBookResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.Map;

public class ImAdditionalBaggageBookResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailExpandReservationParameters params = (RailExpandReservationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.EXPAND_RESERVATION_PARAMETERS);
        Map afParamsWithIndex = (Map)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_ANCILLARY_FEE_PARAMS_WITH_INDEX_MAP);
        ImAdditionalBaggageBookResp response = (ImAdditionalBaggageBookResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        this.updateReservation(reservation, response, params, afParamsWithIndex);
    }

    private void updateReservation(Reservation reservation, ImAdditionalBaggageBookResp response, RailExpandReservationParameters params, Map<RailAncillaryFeeReservationParameters, Integer> afParamsWithIndex) throws Exception {
        for (RailExpandProductParameters productParams : params.getProductParams()) {
            RailwayProduct product = RzdCommonHelper.getProductByUid((Reservation)reservation, (String)productParams.getProductUid());
            if (product == null) {
                throw Xeption.forDeveloper((String)"can't find railway product with uid {0}", (Object[])new Object[]{productParams.getProductUid()});
            }
            for (RailAncillaryFeeReservationParameters afParams : IMHelper.filterBaggage(productParams.getAncillaryFees())) {
                RailwayAncillaryFee ancillaryFee = afParams.getAncillaryFee();
                Integer responseItemIndex = afParamsWithIndex.get(afParams);
                ImAdditionalBaggageBookResp.Item item = response.getItems().stream().filter(it -> MiscUtil.equals((Object)it.getIndex(), (Object)responseItemIndex)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find item with index {0}", (Object[])new Object[]{ancillaryFee.getGdsId()}));
                RailwayMcoProduct mcoProduct = RailwayProductHelper.buildRailwayMcoProduct((RailwayProduct)product, (boolean)true);
                mcoProduct.setStatus(ProductStatus.BOOKING);
                mcoProduct.getImData().setOrderItemId(item.getOrderItemId());
                mcoProduct.setGdsId(item.getOrderItemBlankId());
                mcoProduct.setMcoCategory(IMHelper.convertMcoCategoryByTypeFromGds(item.getType()));
                mcoProduct.setEquivalentFare(item.getAmount());
                Date timeLimit = IMHelper.formatZonedDate(item.getConfirmTill());
                if (!timeLimit.before(reservation.getTimeLimit())) continue;
                IncidentsLog.reportStackTrace((String)("bookingFile " + reservation.getBookingFile().getNumber() + " reservation " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation) + ": railway ancillary fee " + item.getOrderItemBlankId() + " has timeLimit less than reservation timeLimit"));
            }
        }
    }
}

