/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.expandReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMUrlSuffix;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.request.ImAdditionalMealCheckoutReq;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class ImAdditionalMealCheckoutRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailwayAncillaryFee ancillaryFee = (RailwayAncillaryFee)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.ANCILLARY_FEE);
        PaymentType paymentType = (PaymentType)ctx.getObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        RailwayProduct product = RzdCommonHelper.getProductByUid((Reservation)reservation, (String)ancillaryFee.getProductUid());
        if (product == null) {
            throw Xeption.forDeveloper((String)"can't find railway product with uid {0}", (Object[])new Object[]{ancillaryFee.getProductUid()});
        }
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT, (Object)product);
        ctx.putObject((Enum)IBusIMContextKeys.IM_REQUEST_PARAMETERS, (Object)new IMRequestParameters(IMUrlSuffix.AdditionalMealCheckout, this.buildRequest(product, ancillaryFee, paymentType)));
    }

    private ImAdditionalMealCheckoutReq buildRequest(RailwayProduct product, RailwayAncillaryFee ancillaryFee, PaymentType paymentType) {
        ImAdditionalMealCheckoutReq result = new ImAdditionalMealCheckoutReq();
        result.setMainServiceReference(IMHelper.buildMainServiceReference(product));
        result.setPaymentForm(IMHelper.getPaymentForm(paymentType));
        ImAdditionalMealCheckoutReq.MealTime mt = new ImAdditionalMealCheckoutReq.MealTime();
        mt.setMealTime(IMHelper.getMealTime(ancillaryFee.getGdsId()));
        mt.setMealOptionCode(IMHelper.getMealOptionCode(ancillaryFee.getGdsId()));
        result.getMealTimes().add(mt);
        return result;
    }
}

