/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.expandReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.ImAdditionalMealCheckoutResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class ImAdditionalMealCheckoutResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailwayProduct product = (RailwayProduct)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_PRODUCT);
        ImAdditionalMealCheckoutResp response = (ImAdditionalMealCheckoutResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        this.updateReservation(reservation, product, response);
    }

    private void updateReservation(Reservation reservation, RailwayProduct product, ImAdditionalMealCheckoutResp response) throws Exception {
        RailwayMcoProduct mcoProduct = RailwayProductHelper.buildRailwayMcoProduct((RailwayProduct)product, (boolean)true);
        mcoProduct.setStatus(ProductStatus.BOOKING);
        mcoProduct.getImData().setOrderItemId(response.getOrderItemId());
        mcoProduct.setGdsId(response.getOrderItemBlankId());
        mcoProduct.setMcoCategory(RailwayMcoCategory.MEAL);
        mcoProduct.setEquivalentFare(response.getAmount());
        Date timeLimit = IMHelper.formatZonedDate(response.getConfirmTill());
        if (timeLimit.before(reservation.getTimeLimit())) {
            IncidentsLog.reportStackTrace((String)("bookingFile " + reservation.getBookingFile().getNumber() + " reservation " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation) + ": railway ancillary fee " + response.getOrderItemBlankId() + " has timeLimit less than reservation timeLimit"));
        }
    }
}

