/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.getAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.MealOption;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.ImAdditionalMealPricingResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ImAdditionalMealPricingResponseParser
extends BaseProcessor {
    private static final Map<String, String> mealTimeMap = new HashMap<String, String>();

    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        String orderItemId = (String)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_ORDER_ITEM_ID);
        ImAdditionalMealPricingResp response = (ImAdditionalMealPricingResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        ctx.putObject((Enum)IBusMidofficeContextKeys.ANCILLARY_FEES, this.buildAncillaryFees(response, reservation, orderItemId));
    }

    private List<RailwayAncillaryFee> buildAncillaryFees(ImAdditionalMealPricingResp response, Reservation reservation, String orderItemId) {
        return response.getMealOptions().stream().flatMap(mo -> this.buildAncillaryFeesStream((MealOption)mo, reservation, orderItemId)).collect(Collectors.toList());
    }

    private Stream<RailwayAncillaryFee> buildAncillaryFeesStream(MealOption mealOption, Reservation reservation, String orderItemId) {
        return RailwayProductHelper.getRailwayProductStream((Reservation)reservation).filter(rp -> MiscUtil.equals((Object)rp.getImData().getOrderItemId(), (Object)orderItemId)).map(product -> this.buildAncillaryFee(mealOption, (RailwayProduct)product));
    }

    private RailwayAncillaryFee buildAncillaryFee(MealOption mealOption, RailwayProduct product) {
        RailwayAncillaryFee fee = new RailwayAncillaryFee();
        fee.setGds(GdsName.INMOB);
        fee.setGdsId(IMHelper.buildMealGdsId(mealOption.getMealTime(), mealOption.getMealOptionCode()));
        fee.setProductUid(product.getUid());
        fee.setMcoCategory(RailwayMcoCategory.MEAL);
        fee.setMaxQuantityPerPassenger(Integer.valueOf(mealOption.getQuantity()));
        fee.setGdsDescription(mealOption.getDescription());
        fee.setName(this.convertMealTimeFromGds(mealOption.getMealTime()) + ": " + mealOption.getMealName());
        fee.setEquivalentAmount(mealOption.getPricePerUnit());
        return fee;
    }

    private String convertMealTimeFromGds(String gdsValue) {
        return mealTimeMap.get(gdsValue);
    }

    static {
        mealTimeMap.put("Breakfast", "\u0417\u0430\u0432\u0442\u0440\u0430\u043a");
        mealTimeMap.put("Lunch", "\u041e\u0431\u0435\u0434");
        mealTimeMap.put("Dinner", "\u0423\u0436\u0438\u043d");
    }
}

