/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.getAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.ImAvailableBaggageTypesResp;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class ImAvailableBaggageTypesResponseParser
extends BaseProcessor {
    private static Set<RailwayMcoCategory> ONLINE_SUPPORTED_MCO_CATEGORIES = EnumSet.of(RailwayMcoCategory.HAND_BAGGAGE, RailwayMcoCategory.PET_BAGGAGE, RailwayMcoCategory.LUGGAGE_IN_RAILWAY_ROOM);

    public void process(MessageContext ctx) {
        RailwayProduct product = (RailwayProduct)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCT);
        ImAvailableBaggageTypesResp response = (ImAvailableBaggageTypesResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        List result = (List)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusMidofficeContextKeys.ANCILLARY_FEES, ArrayList::new);
        result.addAll(this.buildAncillaryFees(response, product));
    }

    private List<RailwayAncillaryFee> buildAncillaryFees(ImAvailableBaggageTypesResp response, RailwayProduct product) {
        ArrayList<RailwayAncillaryFee> result = new ArrayList<RailwayAncillaryFee>();
        for (ImAvailableBaggageTypesResp.BaggageType gdsBaggage : response.getBaggageTypes()) {
            RailwayMcoCategory mcoCategory = IMHelper.convertMcoCategoryFromGds(gdsBaggage.getType());
            if (!ONLINE_SUPPORTED_MCO_CATEGORIES.contains(mcoCategory)) continue;
            RailwayAncillaryFee fee = new RailwayAncillaryFee();
            fee.setGds(GdsName.INMOB);
            fee.setGdsId(gdsBaggage.getType());
            fee.setProductUid(product.getUid());
            fee.setMcoCategory(mcoCategory);
            fee.setMaxQuantityPerPassenger(Integer.valueOf(gdsBaggage.getQuantity()));
            fee.setGdsDescription(gdsBaggage.getName());
            result.add(fee);
        }
        return result;
    }
}

