/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.getTrainRoute;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdRoutePoint;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMGetTrainRouteResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class IMTrainRouteResponseProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IMGetTrainRouteResp response = (IMGetTrainRouteResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_ROUTES, this.buildRoutes(response));
    }

    private List<RzdRoute> buildRoutes(IMGetTrainRouteResp resp) {
        ArrayList<RzdRoute> result = new ArrayList<RzdRoute>();
        for (IMGetTrainRouteResp.Route route : resp.getRoutes()) {
            RzdRoute rzdRoute = new RzdRoute();
            rzdRoute.setTitle(route.getName());
            rzdRoute.setDeparture(route.getOriginName());
            rzdRoute.setArrival(route.getDestinationName());
            for (IMGetTrainRouteResp.RouteStops routeStops : route.getRouteStops()) {
                RzdRoutePoint point = new RzdRoutePoint();
                point.setStationName(routeStops.getStationName());
                point.setStationCode(routeStops.getStationCode());
                point.setArrivalTime(routeStops.getArrivalTime());
                if (routeStops.getStopDuration() != null) {
                    point.setStopTime(Duration.ofMinutes(routeStops.getStopDuration().intValue()));
                }
                point.setDepartureTime(routeStops.getDepartureTime());
                point.setTimeDescription(routeStops.getTimeDescription());
                rzdRoute.getPoints().add(point);
            }
            result.add(rzdRoute);
        }
        return result;
    }
}

