/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.getTrainSeats;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMUrlSuffix;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.request.IMSearchCarPricingReq;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class IMGetTrainSeatsRequestBuilder
extends BaseProcessor {
    private boolean isChild = false;

    public void configure(Map<String, String> parameters) {
        String isChildStr = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"isChild", (String)"false");
        this.isChild = Boolean.valueOf(isChildStr);
    }

    public void process(MessageContext ctx) throws Exception {
        RzdGetTrainSeatsParameters params = (RzdGetTrainSeatsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_PARAMETERS);
        ctx.putObject((Enum)IBusIMContextKeys.IM_REQUEST_PARAMETERS, (Object)new IMRequestParameters(IMUrlSuffix.CarPricing, this.buildRequestData(params)));
    }

    private IMSearchCarPricingReq buildRequestData(RzdGetTrainSeatsParameters params) throws Exception {
        IMSearchCarPricingReq entity = new IMSearchCarPricingReq();
        entity.setOrigin(params.getDeparture().getCode());
        entity.setDestination(params.getArrival().getCode());
        entity.setDepartureDate(IMHelper.formatDate(params.getDepartureDate()));
        entity.setTrainNumber(params.getTrainNumber());
        entity.setCarType(IMHelper.convertCarriageTypeToGds(params.getCarriageType()));
        if (this.isChild) {
            entity.setTariffType("Child");
        }
        entity.setProvider(params.getTrainProvider());
        return entity;
    }
}

