/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.getTrainSeats;

import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBonusCardType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsResult;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRoutePolicy;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.BaseCarriage;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Carriage;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.TrainInfo;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMSearchCarPricingResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IMGetTrainSeatsResponseProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        IMSearchCarPricingResp response = (IMSearchCarPricingResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_RESULT, (Object)this.buildResult(response));
    }

    private RzdGetTrainSeatsResult buildResult(IMSearchCarPricingResp resp) {
        RzdGetTrainSeatsResult result = new RzdGetTrainSeatsResult();
        TrainInfo info = resp.getInfo();
        String routePolicy = resp.getRoutePolicy();
        for (Carriage car : resp.getCarriageList()) {
            RzdPrice price = this.buildPrice(car, info, routePolicy, resp.getAllowedDocumentTypes());
            if (price == null) continue;
            result.getPrices().add(price);
        }
        return result;
    }

    private RzdPrice buildPrice(Carriage car, TrainInfo info, String routePolicy, List<String> availableDocuments) {
        if (!IMHelper.isAvailable(car)) {
            return null;
        }
        CarriageType carriageType = IMHelper.convertCarriageTypeFromGds(car.getCarType());
        if (carriageType == null) {
            return null;
        }
        RzdPrice price = new RzdPrice();
        price.setCategory(carriageType);
        price.setCategoryTitle(car.getCarTypeName());
        price.getAvailableTariffs().addAll(this.buildAvailableTariffs(routePolicy, car, info));
        price.getAvailableDocuments().addAll(availableDocuments.stream().map(IMHelper::convertPassportTypeFromGds).filter(Objects::nonNull).collect(Collectors.toList()));
        price.getAvailableBonusCards().addAll(this.buildAvailableBonusCards(car.getRzhdCardTypes()));
        price.setPrice(IMHelper.buildPriceValues(car));
        String serviceClassStr = car.getServiceClass();
        price.setServiceClass(RzdServiceConverter.getServiceClassByName((String)serviceClassStr));
        price.setServiceClassCode(serviceClassStr);
        price.setServiceDescription(car.getServiceClassTranscript());
        car.getServices().stream().map(RzdHelper::getRailServiceByProviderCode).filter(Objects::nonNull).forEach(price.getServicesList()::add);
        price.setSubcategory(car.getCarDescription());
        price.setPassengerSpecifyingRule(car.getSpecifyingRules());
        price.setSeatsIncluded(IMHelper.calculateIncludedSeats(car.getSpecifyingRules()));
        price.setRoute(car.getRoute());
        price.setCarrier(RzdHelper.getCarrier(car.getCarOwner()));
        price.setWithDiscount(!car.getDiscounts().isEmpty());
        String intServClass = car.getInternationalServiceClass();
        price.setInternationalServiceClass(intServClass);
        price.setMealOptionPossible(car.isMealOptionPossible() || car.isAdditionalMealOptionPossible() || car.isOnRequestMealOptionPossible());
        price.setTrainNumber(info.getTrainNumber());
        price.setTrainName(info.getTrainBrand());
        price.setDepartureDatetime(DateUtils.toJavaDate((LocalDateTime)info.getDepartureDate()));
        price.getCars().addAll(this.getRzdCar(car, DateUtils.toJavaDate((LocalDateTime)info.getArrivalDate())));
        return price;
    }

    private List<RzdCar> getRzdCar(Carriage car, Date trainArrivalDt) {
        RzdCar rzdCar = this.toRzdCar(car);
        if (rzdCar.getArrivalDatetime() == null) {
            rzdCar.setArrivalDatetime(trainArrivalDt);
        }
        return Collections.singletonList(rzdCar);
    }

    private Set<RzdTariff> buildAvailableTariffs(String routePolicy, Carriage car, TrainInfo train) {
        List<BaseCarriage.Discount> discounts = car.getDiscounts();
        HashSet<RzdTariff> tariffs = new HashSet<RzdTariff>(IMRoutePolicy.valueOf(routePolicy.toUpperCase()).getTariffs());
        if (!discounts.isEmpty()) {
            tariffs.addAll(discounts.stream().map(disc -> IMHelper.convertGdsTariffTypeToRzdTariff(disc.getDiscountType())).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (BooleanUtil.nullAsFalse((Boolean)train.isSuburban())) {
            tariffs.removeIf(tariff -> DictHelper.isInfantPassengerType((DictionaryReference)RzdCommonHelper.rzdTariffToPassengerType((RzdTariff)tariff)));
        }
        return tariffs;
    }

    private Collection<RzdBonusCardType> buildAvailableBonusCards(List<String> gdsCardTypes) {
        if (CollectionUtil.isEmpty(gdsCardTypes)) {
            return Collections.emptyList();
        }
        return gdsCardTypes.stream().map(IMHelper::convertBonusCardTypeFromGds).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private RzdCar toRzdCar(Carriage car) {
        RzdCar rzdCar = new RzdCar();
        rzdCar.setTrainNumber(car.getTrainNumber());
        rzdCar.setNumber(car.getCarNumber());
        rzdCar.setERegEnabled(car.isHasEReg());
        rzdCar.setPrepaidMeal(car.isMealOptionPossible());
        IMHelper.fillAvailableAncillaryFees(rzdCar.getAvailableAncillaryFees(), car);
        rzdCar.setTwoStoreyed(car.isTwoStoreyed());
        rzdCar.setBeddingEnabled(car.isBeddingSelection());
        rzdCar.setTotalPlaceCount(MiscUtil.guarded((Integer)car.getPlaceQuantity()).intValue());
        rzdCar.setCarPlaceType(IMHelper.convertCarPlaceTypeFromGds(car.getCarPlaceType()));
        rzdCar.getVacantSeats().addAll(this.convertSeatsToStringList(car.getFreePlaces()));
        rzdCar.setHasNonRefundableTariff(car.isOnlyNonRefundableTariff() || car.isHasNonRefundableTariff());
        rzdCar.setCarSubType(car.getCarSubType());
        rzdCar.setArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)car.getArrivalDateTime()));
        rzdCar.setLocalArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)car.getLocalArrivalDateTime()));
        rzdCar.setProviderCarSchemeId(car.getRailwayCarSchemeId());
        return rzdCar;
    }

    private List<String> convertSeatsToStringList(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return TextUtil.split((String)value, (String)",", (boolean)true, (boolean)true);
    }
}

