/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.getTrainSeats;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsResult;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Carriage;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMSearchCarPricingResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;

public class SetChildPricesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RzdGetTrainSeatsResult trainSeatsResult = (RzdGetTrainSeatsResult)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_RESULT);
        IMSearchCarPricingResp response = (IMSearchCarPricingResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        this.setChildPrices(trainSeatsResult, response);
    }

    private void setChildPrices(RzdGetTrainSeatsResult trainSeatsResult, IMSearchCarPricingResp response) {
        for (RzdPrice rzdPrice : trainSeatsResult.getPrices()) {
            Carriage gdsCar = this.findCarriage(response, rzdPrice);
            if (gdsCar == null) continue;
            rzdPrice.setChildPrice(IMHelper.buildPriceValues(gdsCar));
        }
    }

    private Carriage findCarriage(IMSearchCarPricingResp response, RzdPrice rzdPrice) {
        return response.getCarriageList().stream().filter(car -> this.isSame((Carriage)car, rzdPrice)).findFirst().orElse(null);
    }

    private boolean isSame(Carriage car, RzdPrice rzdPrice) {
        if (rzdPrice.getCars().isEmpty()) {
            return false;
        }
        RzdCar rzdCar = (RzdCar)rzdPrice.getCars().get(0);
        if (!MiscUtil.equals((Object)rzdCar.getCarPlaceType(), (Object)IMHelper.convertCarPlaceTypeFromGds(car.getCarPlaceType()))) {
            return false;
        }
        if (!MiscUtil.equals((Object)rzdCar.getNumber(), (Object)car.getCarNumber())) {
            return false;
        }
        return MiscUtil.equals((Object)rzdPrice.getServiceClass(), (Object)RzdServiceConverter.getServiceClassByName((String)car.getServiceClass()));
    }
}

