/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.priceAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandProductParameters;
import com.gridnine.xtrip.common.railway.model.RailPriceAncillaryFeesReservationParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMUrlSuffix;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.MainServiceReference;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.request.IMRequest;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.request.ImAdditionalBaggagePricingReq;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.Map;

public class ImPriceAncillaryFeesRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailPriceAncillaryFeesReservationParameters params = (RailPriceAncillaryFeesReservationParameters)ctx.getObject((Enum)IBusMidofficeContextKeys.PRICE_ANCILLARY_FEES_RESERVATION_PARAMETERS);
        HashMap<RailAncillaryFeeReservationParameters, Integer> afParamsWithIndex = new HashMap<RailAncillaryFeeReservationParameters, Integer>();
        ctx.putObject((Enum)IBusIMContextKeys.IM_REQUEST_PARAMETERS, (Object)new IMRequestParameters(IMUrlSuffix.AdditionalBaggagePricing, this.buildRequest(reservation, params, afParamsWithIndex)));
        ctx.putObject((Enum)IBusIMContextKeys.IM_ANCILLARY_FEE_PARAMS_WITH_INDEX_MAP, afParamsWithIndex);
    }

    private IMRequest buildRequest(Reservation reservation, RailPriceAncillaryFeesReservationParameters params, Map<RailAncillaryFeeReservationParameters, Integer> afParamsWithIndex) {
        ImAdditionalBaggagePricingReq result = new ImAdditionalBaggagePricingReq();
        for (RailExpandProductParameters productParams : params.getProductParams()) {
            RailwayProduct product = RzdCommonHelper.getProductByUid((Reservation)reservation, (String)productParams.getProductUid());
            if (product == null) {
                throw Xeption.forDeveloper((String)"can't find railway product with uid {0}", (Object[])new Object[]{productParams.getProductUid()});
            }
            IMHelper.filterBaggage(productParams.getAncillaryFees()).stream().map(afp -> this.buildItem(product, (RailAncillaryFeeReservationParameters)afp, afParamsWithIndex, result.getItems().size() + 1)).forEach(result.getItems()::add);
        }
        return result;
    }

    private ImAdditionalBaggagePricingReq.BaggagePricingItem buildItem(RailwayProduct product, RailAncillaryFeeReservationParameters params, Map<RailAncillaryFeeReservationParameters, Integer> afParamsWithIndex, int index) {
        ImAdditionalBaggagePricingReq.BaggagePricingItem result = new ImAdditionalBaggagePricingReq.BaggagePricingItem();
        MainServiceReference serviceRef = new MainServiceReference();
        serviceRef.setOrderItemId(IMHelper.getOrderItemId(product));
        serviceRef.setOrderItemBlankId(product.getBlankId());
        result.setMainServiceReference(serviceRef);
        result.setBaggageRequest(IMHelper.buildBaggageRequest(params.getAncillaryFee().getMcoCategory(), params.getBaggageParameters()));
        result.setIndex(index);
        afParamsWithIndex.put(params, index);
        return result;
    }
}

