/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.priceAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandProductParameters;
import com.gridnine.xtrip.common.railway.model.RailPriceAncillaryFeesReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.ImAdditionalBaggagePricingResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ImPriceAncillaryFeesResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailPriceAncillaryFeesReservationParameters params = (RailPriceAncillaryFeesReservationParameters)ctx.getObject((Enum)IBusMidofficeContextKeys.PRICE_ANCILLARY_FEES_RESERVATION_PARAMETERS);
        Map afParamsWithIndex = (Map)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_ANCILLARY_FEE_PARAMS_WITH_INDEX_MAP);
        ImAdditionalBaggagePricingResp response = (ImAdditionalBaggagePricingResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        ctx.putObject((Enum)IBusMidofficeContextKeys.ANCILLARY_FEES, this.buildAncillaryFees(response, reservation, params, afParamsWithIndex));
    }

    private List<RailwayAncillaryFee> buildAncillaryFees(ImAdditionalBaggagePricingResp response, Reservation reservation, RailPriceAncillaryFeesReservationParameters params, Map<RailAncillaryFeeReservationParameters, Integer> afParamsWithIndex) {
        ArrayList<RailwayAncillaryFee> result = new ArrayList<RailwayAncillaryFee>();
        for (RailExpandProductParameters productParams : params.getProductParams()) {
            RailwayProduct product = RzdCommonHelper.getProductByUid((Reservation)reservation, (String)productParams.getProductUid());
            if (product == null) {
                throw Xeption.forDeveloper((String)"can't find railway product with uid {0}", (Object[])new Object[]{productParams.getProductUid()});
            }
            for (RailAncillaryFeeReservationParameters afParams : IMHelper.filterBaggage(productParams.getAncillaryFees())) {
                Integer responseItemIndex = afParamsWithIndex.get(afParams);
                RailwayAncillaryFee ancillaryFee = afParams.getAncillaryFee();
                ImAdditionalBaggagePricingResp.Item item = response.getItems().stream().filter(it -> MiscUtil.equals((Object)it.getIndex(), (Object)responseItemIndex)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find item with index {0}", (Object[])new Object[]{ancillaryFee.getGdsId()}));
                ancillaryFee.setEquivalentAmount(item.getAmount());
                result.add(ancillaryFee);
            }
        }
        return result;
    }
}

