/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.priceAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeHandBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeLuggageInRailwayRoomParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeePetBaggageParameters;
import com.gridnine.xtrip.common.railway.model.RailAncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailExpandProductParameters;
import com.gridnine.xtrip.common.railway.model.RailPriceAncillaryFeesReservationParameters;
import com.gridnine.xtrip.common.railway.model.RailwayAncillaryFee;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class ImPriceAncillaryFeesValidator
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        RailPriceAncillaryFeesReservationParameters params = (RailPriceAncillaryFeesReservationParameters)ctx.getObject((Enum)IBusMidofficeContextKeys.PRICE_ANCILLARY_FEES_RESERVATION_PARAMETERS);
        this.validate(reservation, params);
    }

    private void validate(Reservation reservation, RailPriceAncillaryFeesReservationParameters params) {
        for (RailExpandProductParameters productParams : params.getProductParams()) {
            RailwayProduct product = RzdCommonHelper.getProductByUid((Reservation)reservation, (String)productParams.getProductUid());
            if (product == null) {
                throw Xeption.forDeveloper((String)"can't find railway product with uid {0}", (Object[])new Object[]{productParams.getProductUid()});
            }
            IMHelper.filterBaggage(productParams.getAncillaryFees()).forEach(this::validateBaggage);
        }
    }

    private void validateBaggage(RailAncillaryFeeReservationParameters afParams) {
        RailwayAncillaryFee ancillaryFee = afParams.getAncillaryFee();
        if (MiscUtil.guarded((Integer)ancillaryFee.getQuantity()) > 1) {
            throw Xeption.forDeveloper((String)"baggage ancillary fee doesn't support quantity > 1", (Object[])new Object[0]);
        }
        RailwayMcoCategory mcoCategory = ancillaryFee.getMcoCategory();
        RailAncillaryFeeBaggageParameters baggageParams = afParams.getBaggageParameters();
        if (baggageParams == null) {
            throw Xeption.forDeveloper((String)"baggage params is empty in the baggage ancillary fee", (Object[])new Object[0]);
        }
        switch (mcoCategory) {
            case HAND_BAGGAGE: {
                this.validate((RailAncillaryFeeHandBaggageParameters)baggageParams);
                break;
            }
            case PET_BAGGAGE: {
                this.validate((RailAncillaryFeePetBaggageParameters)baggageParams);
                break;
            }
            case LUGGAGE_IN_RAILWAY_ROOM: {
                this.validate((RailAncillaryFeeLuggageInRailwayRoomParameters)baggageParams);
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"Unsupported mcoCategory {0}", (Object[])new Object[]{mcoCategory});
            }
        }
    }

    private void validate(RailAncillaryFeeHandBaggageParameters params) {
        if (params.getType() == null) {
            params.getValidationContext().getTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (TextUtil.isBlank((String)params.getDescription())) {
            params.getValidationContext().getDescriptionValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
    }

    private void validate(RailAncillaryFeePetBaggageParameters params) {
        if (TextUtil.isBlank((String)params.getDescription())) {
            params.getValidationContext().getDescriptionValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
    }

    private void validate(RailAncillaryFeeLuggageInRailwayRoomParameters params) {
        if (TextUtil.isBlank((String)params.getDescription())) {
            params.getValidationContext().getDescriptionValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (params.getPlaceQuantity() == null) {
            params.getValidationContext().getPlaceQuantityValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else if (params.getPlaceQuantity() < 1 || params.getPlaceQuantity() > 3) {
            params.getValidationContext().getPlaceQuantityValidationMessages().add(RzdValidationMessages.getIvalidValueNumberRange((int)1, (int)3));
        }
        if (params.getDeclaredPrice() == null) {
            params.getValidationContext().getDeclaredPriceValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else if (params.getDeclaredPrice() < 100 || params.getDeclaredPrice() > 9999999) {
            params.getValidationContext().getDeclaredPriceValidationMessages().add(RzdValidationMessages.getIvalidValueNumberRange((int)100, (int)9999999));
        }
    }
}

