/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.refund;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class IMRailwayRefundBlankIdProvider
extends BaseTargetsProvider<Pair<String>> {
    public Collection<Pair<String>> getTargets(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List products = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        Map<String, List<RailwayProduct>> orderItemProductsMap = products.stream().map(RailwayProduct.class::cast).filter(rp -> StringUtils.isNotBlank((String)rp.getBlankId())).collect(Collectors.groupingBy(IMHelper::getOrderItemId));
        ArrayList<Pair<String>> result = new ArrayList<Pair<String>>();
        for (Map.Entry<String, List<RailwayProduct>> entry : orderItemProductsMap.entrySet()) {
            String orderItemId = entry.getKey();
            List<RailwayProduct> orderItemProducts = entry.getValue();
            for (String blankId : this.getBlankIds(reservation, orderItemId, orderItemProducts)) {
                result.add((Pair<String>)new Pair((Object)orderItemId, (Object)blankId));
            }
        }
        return result;
    }

    private Collection<String> getBlankIds(Reservation reservation, String orderItemId, List<RailwayProduct> products) {
        if (this.isRefundAllProducts(reservation, orderItemId, products)) {
            return this.getBlankIdsForFullRefund(products);
        }
        return RailwayHelper.getSortedBlankIdsByUids(reservation, products);
    }

    private boolean isRefundAllProducts(Reservation reservation, String orderItemId, List<RailwayProduct> products) {
        for (BaseProduct bp : reservation.getProducts()) {
            RailwayProduct rp;
            if (!(bp instanceof RailwayProduct) || !MiscUtil.equals((Object)orderItemId, (Object)IMHelper.getOrderItemId(rp = (RailwayProduct)bp))) continue;
            if (rp.getStatus() != ProductStatus.SELL) {
                return false;
            }
            if (products.contains(rp)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getBlankIdsForFullRefund(List<RailwayProduct> products) {
        List nonEmptyBlankIds = products.stream().map(RailwayProduct::getBlankId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (nonEmptyBlankIds.size() == 1) {
            return Collections.singleton(nonEmptyBlankIds.get(0));
        }
        return Collections.singleton(null);
    }
}

