/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.searchSchedule;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.ScheduleTrain;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMGetTimeTableResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IMTimeTableResponseProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IMGetTimeTableResp response = (IMGetTimeTableResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        RzdAbstractSearchParameters params = (RzdAbstractSearchParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_SCHEDULE_PARAMETERS);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_SCHEDULE_TRAINS, this.buildScheduleTrains(response, params.getDepartureDate()));
    }

    private List<ScheduleTrain> buildScheduleTrains(IMGetTimeTableResp response, Date departureDate) throws Exception {
        ArrayList<ScheduleTrain> result = new ArrayList<ScheduleTrain>();
        for (IMGetTimeTableResp.Schedule schedule : response.getSchedules()) {
            ScheduleTrain res = new ScheduleTrain();
            res.setGds(GdsName.INMOB);
            res.setTrainNumber(schedule.getTrainNumber());
            res.setTrainTitle(schedule.getTrainName());
            res.setTrainDeparture(schedule.getDepartureTime());
            res.setTrainArrival(schedule.getArrivalTime());
            Integer wayTimeSeconds = schedule.getTripDuration() * 60;
            res.setDepartureDate(IMHelper.addTimeToDate(departureDate, schedule.getDepartureTime()));
            res.setArrivalDate(IMHelper.addTimeToDate(departureDate, schedule.getArrivalTime()));
            res.setWayTime(wayTimeSeconds);
            res.setTimetable(schedule.getRegularity());
        }
        return result;
    }
}

