/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.searchTrains;

import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdSearchTrainsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.RzdHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.BaseCarriage;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.CarriageSummary;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Train;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMSearchTrainPricingResp;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class IMSearchTrainResponseProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        IMSearchTrainPricingResp response = (IMSearchTrainPricingResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        RzdSearchTrainsParameters searchParams = (RzdSearchTrainsParameters)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_PARAMETERS);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_SEARCH_TRAINS_LIST, this.buildTrains(response, searchParams));
    }

    private List<RzdTrainWithCategories> buildTrains(IMSearchTrainPricingResp response, RzdSearchTrainsParameters searchParams) {
        boolean isBusinessClass = BooleanUtils.isTrue((Boolean)searchParams.getBusinessClass());
        ArrayList<RzdTrainWithCategories> resultList = new ArrayList<RzdTrainWithCategories>();
        if (response != null) {
            for (Train train : response.getTrains()) {
                if (!"Train".equals(train.getTransportType())) continue;
                boolean isGroupByServiceClass = this.isGroupByServiceClass(train);
                RzdTrainWithCategories result = new RzdTrainWithCategories();
                RzdTrain rzdTrain = this.buildTrain(train, searchParams.getPassengersTypes());
                rzdTrain.setGroupedByServiceClass(isGroupByServiceClass);
                result.setTrain(rzdTrain);
                if (isBusinessClass) {
                    this.filterCarriagesForBusinessClass(train.getCarriages());
                }
                HashMap<String, RzdCategory> carsMap = new HashMap<String, RzdCategory>();
                for (CarriageSummary car : train.getCarriages()) {
                    if (!IMHelper.isAvailable(car)) continue;
                    String key = this.buildKey(car, isGroupByServiceClass);
                    RzdCategory category = (RzdCategory)carsMap.get(key);
                    if (category == null) {
                        category = this.buildCategory(car);
                        if (category == null) continue;
                        category.setTrainNumber(train.getTrainNumber());
                        result.getCategories().add(category);
                        carsMap.put(key, category);
                        continue;
                    }
                    this.addCarInfo(category, car);
                }
                if (result.getCategories().isEmpty()) continue;
                resultList.add(result);
            }
        }
        return resultList;
    }

    private String buildKey(CarriageSummary car, boolean isGroupByServiceClass) {
        return isGroupByServiceClass && CollectionUtil.isNotEmpty(car.getServiceClasses()) ? car.getServiceClasses().get(0) : car.getCarType();
    }

    private boolean isGroupByServiceClass(Train train) {
        if (!RzdCommonHelper.isSapsan((String)train.getTrainBrand())) {
            return false;
        }
        Set carTypes = train.getCarriages().stream().map(BaseCarriage::getCarType).filter(Objects::nonNull).collect(Collectors.toSet());
        return carTypes.size() == 1;
    }

    private RzdTrain buildTrain(Train train, Map<DictionaryReference<PassengerType>, Integer> passengersTypes) {
        RzdTrain rzdTrain = new RzdTrain();
        rzdTrain.setNumber(train.getTrainNumber());
        rzdTrain.setDisplayNumber(train.getDisplayTrainNumber());
        rzdTrain.setCategory(train.getTrainCategory());
        rzdTrain.setBrand(train.getTrainBrand());
        rzdTrain.setDeparture(train.getDeparture());
        rzdTrain.setArrival(train.getArrival());
        rzdTrain.setPassengerFrom(RzdHelper.getStationRefByCode(train.getDepartureStationCode()));
        rzdTrain.setPassengerTo(RzdHelper.getStationRefByCode(train.getArrivalStationCode()));
        rzdTrain.setDepartureDatetime(DateUtils.toJavaDate((LocalDateTime)train.getDepartureDate()));
        rzdTrain.setArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)train.getArrivalDate()));
        rzdTrain.setLocalDepartureDatetime(DateUtils.toJavaDate((LocalDateTime)train.getLocalDepartureDate()));
        rzdTrain.setLocalArrivalDatetime(DateUtils.toJavaDate((LocalDateTime)train.getLocalArrivalDate()));
        rzdTrain.setCarWithOtherArrivalTimeExists(train.getArrivalDateTimes() != null && train.getArrivalDateTimes().size() > 1);
        rzdTrain.setWayTime(train.getTripDuration());
        rzdTrain.setERegEnabled(train.isHasElectronicRegistration());
        rzdTrain.getServiceList().addAll(train.getCarServices().stream().map(RzdHelper::getRailServiceByProviderCode).filter(Objects::nonNull).collect(Collectors.toList()));
        rzdTrain.setTrainProvider(train.getProvider());
        this.setDisabled(rzdTrain, train, passengersTypes);
        return rzdTrain;
    }

    private RzdCategory buildCategory(CarriageSummary carriage) {
        CarriageType carriageType = IMHelper.convertCarriageTypeFromGds(carriage.getCarType());
        if (carriageType == null) {
            return null;
        }
        RzdCategory category = new RzdCategory();
        category.setCarriageType(carriageType);
        category.setPriceOriginalMin(carriage.getMinPrice());
        category.setSeatsCount(carriage.getTotalPlaceQuantity());
        category.setGenderSeatsCountSupported(true);
        category.setMaleSeatsCount(carriage.getMalePlaceQuantity());
        category.setFemaleSeatsCount(carriage.getFemalePlaceQuantity());
        category.setMixedSeatsCount(carriage.getMixedCabinQuantity());
        category.setUndefinedSeatsCount(carriage.getEmptyCabinQuantity());
        String carOwner = String.join((CharSequence)", ", carriage.getCarOwners());
        category.setCarrier(RzdHelper.getCarrier(carOwner));
        String subCategory = this.getSubCategory(carriage);
        category.setSubcategory(subCategory);
        this.addServiceClasses(category, carriage);
        category.setMealOptionPossible(carriage.isMealOptionPossible() || carriage.isAdditionalMealOptionPossible() || carriage.isOnRequestMealOptionPossible());
        category.setPrepaidMeal(carriage.isMealOptionPossible());
        IMHelper.fillAvailableAncillaryFees(category.getAvailableAncillaryFees(), carriage);
        if (!carriage.getDiscounts().isEmpty()) {
            category.setWithDiscount(true);
            category.setHasRoundTripDiscount(carriage.getDiscounts().stream().anyMatch(d -> d.getDiscountType() != null && (d.getDiscountType().equals("RoundTrip") || d.getDiscountType().equals("RoundTripInInterstateDirection"))));
        }
        return category;
    }

    private String getSubCategory(CarriageSummary carriage) {
        return carriage.getCarDescriptions().stream().findFirst().orElse("");
    }

    private void addServiceClasses(RzdCategory category, CarriageSummary carriage) {
        if (CollectionUtil.isEmpty(carriage.getServiceClasses())) {
            return;
        }
        carriage.getServiceClasses().stream().map(RzdServiceConverter::getServiceClassByName).filter(Objects::nonNull).forEach(category.getServiceClasses()::add);
    }

    private void addCarInfo(RzdCategory category, CarriageSummary carriage) {
        category.setPriceOriginalMin(MiscUtil.minimum((BigDecimal[])new BigDecimal[]{carriage.getMinPrice(), category.getPriceOriginalMin()}));
        category.setSeatsCount(Integer.valueOf(carriage.getTotalPlaceQuantity() + category.getSeatsCount()));
        if (carriage.getMalePlaceQuantity() != null) {
            category.setMaleSeatsCount(Integer.valueOf(carriage.getMalePlaceQuantity() + MiscUtil.guarded((Integer)category.getMaleSeatsCount())));
        }
        if (carriage.getFemalePlaceQuantity() != null) {
            category.setFemaleSeatsCount(Integer.valueOf(carriage.getFemalePlaceQuantity() + MiscUtil.guarded((Integer)category.getFemaleSeatsCount())));
        }
        if (carriage.getMixedCabinQuantity() != null) {
            category.setMixedSeatsCount(Integer.valueOf(carriage.getMixedCabinQuantity() + MiscUtil.guarded((Integer)category.getMixedSeatsCount())));
        }
        if (carriage.getEmptyCabinQuantity() != null) {
            category.setUndefinedSeatsCount(Integer.valueOf(carriage.getEmptyCabinQuantity() + MiscUtil.guarded((Integer)category.getUndefinedSeatsCount())));
        }
        category.setSubcategory(RailwayHelper.mergeSubCategories(category.getSubcategory(), this.getSubCategory(carriage)));
        this.addServiceClasses(category, carriage);
    }

    private void filterCarriagesForBusinessClass(List<CarriageSummary> carriages) {
        carriages.removeIf(car -> car.getServiceClasses().stream().noneMatch(sc -> sc.startsWith("1")));
    }

    private void setDisabled(RzdTrain rzdTrain, Train train, Map<DictionaryReference<PassengerType>, Integer> passengersTypes) {
        if (BooleanUtil.nullAsFalse((Boolean)train.isSuburban()) && passengersTypes.containsKey(DictHelper.getInfantPassengerType())) {
            rzdTrain.setDisabled(true);
            rzdTrain.setDisableReason(L10nResourcesManager.createL10nMessage((String)Messages.RAIL_TRAIN_NOT_SUPPORT_INFANT_TARIFF, (Object[])new Object[0]));
        }
    }
}

