/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.setEReg;

import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMElectronicRegistrationResp;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.ERegBlankInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class IMERegResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IMElectronicRegistrationResp response = (IMElectronicRegistrationResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_EREG_BLANKS, IMERegResponseParser.buildERegBlanks(response));
    }

    public static List<ERegBlankInfo> buildERegBlanks(IMElectronicRegistrationResp response) {
        ArrayList<ERegBlankInfo> result = new ArrayList<ERegBlankInfo>();
        for (IMElectronicRegistrationResp.ERegBlank gdsBlank : response.getBlanks()) {
            ERegBlankInfo bi = new ERegBlankInfo();
            RzdStatus rzdStatus = IMHelper.convertStatusFromGds(gdsBlank.getStatus());
            bi.setHasEReg(rzdStatus == RzdStatus.WITH_ER);
            bi.setBlankId(gdsBlank.getBlankId());
            result.add(bi);
        }
        return result;
    }
}

