/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMRequestParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMUrlSuffix;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.request.IMConfirmReservationReq;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class IMConfirmTicketRequestBuilder
extends BaseProcessor {
    private String operation;

    public void configure(Map<String, String> parameters) {
        this.operation = parameters.get("operation");
    }

    public void process(MessageContext ctx) {
        IMRequestParameters params;
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        PaymentType payment = (PaymentType)ctx.getObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        if ("confirm".equals(this.operation)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0447\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}", (Object[])new Object[]{recordLocator}));
            params = new IMRequestParameters(IMUrlSuffix.ConfirmTicket, this.buildRequestData(reservation, payment));
        } else if ("prolong".equals(this.operation)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0422\u0440\u0435\u0445\u0447\u0430\u0441\u043e\u0432\u043e\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}", (Object[])new Object[]{recordLocator}));
            params = new IMRequestParameters(IMUrlSuffix.ReservationProlong, this.buildRequestData(reservation, null));
        } else if ("cancel".equals(this.operation)) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0447\u0430\u0442\u0430 \u043e\u0442\u043c\u0435\u043d\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}", (Object[])new Object[]{recordLocator}));
            params = new IMRequestParameters(IMUrlSuffix.ReservationCancel, this.buildRequestData(reservation, null));
        } else {
            throw Xeption.forDeveloper((String)"unsupported operation {0}", (Object[])new Object[]{this.operation});
        }
        ctx.putObject((Enum)IBusIMContextKeys.IM_REQUEST_PARAMETERS, (Object)params);
    }

    private IMConfirmReservationReq buildRequestData(Reservation reservation, PaymentType pt) {
        IMConfirmReservationReq req = new IMConfirmReservationReq();
        req.setOrderID(IMHelper.getOrderId(reservation));
        req.setPaymentForm(IMHelper.getPaymentForm(pt));
        return req;
    }
}

