/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.im.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.RailwayHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IMHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.entities.Blank;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMConfirmReservationResp;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class IMConfirmTicketResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        IMConfirmReservationResp response = (IMConfirmReservationResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        PaymentType paymentType = (PaymentType)ctx.getObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        this.ticketReservation(reservation, response, paymentType);
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0432\u044b\u043f\u0438\u0441\u0430\u043d\u043e", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKETED, (Object)Boolean.TRUE);
    }

    private void ticketReservation(Reservation reservation, IMConfirmReservationResp response, PaymentType paymentType) throws Exception {
        Date curDate = new Date();
        for (IMConfirmReservationResp.ConfirmResult confirmResult : response.getResults()) {
            if (confirmResult.getErrorResult() != null) {
                throw Xeption.forAdmin((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u0431\u0438\u043b\u0435\u0442\u0430! : ", (Object[])new Object[]{confirmResult.getErrorResult()});
            }
            String eRegExpireDateStr = confirmResult.getERegExpirationTime();
            Date eRegExpireDate = IMHelper.formatZonedDate(eRegExpireDateStr);
            if (confirmResult.getMainServiceReference() != null) {
                List mcoProducts = BookingStreamHelper.getProductsStream((Reservation)reservation, RailwayMcoProduct.class).filter(rp -> MiscUtil.equals((Object)rp.getImData().getOrderItemId(), (Object)confirmResult.getOrderItemId())).collect(Collectors.toList());
                RailwayMcoProduct mcoProduct = (RailwayMcoProduct)CollectionUtil.single(mcoProducts);
                mcoProduct.setStatus(ProductStatus.SELL);
                mcoProduct.setSystemNumber(confirmResult.getVoucherNumber());
                mcoProduct.setIssueDate(curDate);
                GeneralProductHelper.updateFops((BaseProduct)mcoProduct);
                continue;
            }
            for (Blank blank : confirmResult.getBlanks()) {
                RailwayProduct rp2 = RzdCommonHelper.getProductByBlankId((Reservation)reservation, (String)blank.getBlankId());
                if (rp2 == null) {
                    throw Xeption.forDeveloper((String)"can't find railway product with blankId {0}", (Object[])new Object[]{blank.getBlankId()});
                }
                rp2.setSystemNumber(blank.getNumber());
                rp2.setStatus(ProductStatus.SELL);
                rp2.setIssueDate(curDate);
                rp2.setRefundExpireDate(IMHelper.formatZonedDate(blank.getOnlineTicketReturnExpirationDateTime()));
                rp2.setERegExpireDate(eRegExpireDate);
                if (paymentType != null) {
                    rp2.setPaymentType(paymentType);
                }
                RzdStatus rzdStatus = IMHelper.convertStatusFromGds(blank.getStatus());
                rp2.setIbecorpRzdStatus(rzdStatus);
                RailwayHelper.updateEReg(rp2, rzdStatus == RzdStatus.WITH_ER);
                RailwayProductHelper.updateFops((RailwayProduct)rp2);
            }
        }
    }
}

